/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.suggestion.parser;

import com.atlassian.bitbucket.internal.suggestion.parser.CommonMarkSuggestionParser;
import java.util.Map;
import org.commonmark.Extension;
import org.commonmark.node.Node;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.HtmlRenderer;

public class SuggestionIndexingExtension
implements HtmlRenderer.HtmlRendererExtension {
    private SuggestionIndexingExtension() {
    }

    public static Extension create() {
        return new SuggestionIndexingExtension();
    }

    public void extend(HtmlRenderer.Builder rendererBuilder) {
        rendererBuilder.attributeProviderFactory(context -> new SuggestionIndexAttributeProvider());
    }

    private static class SuggestionIndexAttributeProvider
    implements AttributeProvider {
        private int index;

        private SuggestionIndexAttributeProvider() {
        }

        public void setAttributes(Node node, String tagName, Map<String, String> attributes) {
            if (CommonMarkSuggestionParser.IS_SUGGESTION.test(node) && "code".equals(tagName)) {
                attributes.put("data-suggestion-index", Integer.toString(this.index++));
            }
        }
    }
}

