/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.suggestion;

import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.dmz.suggestion.DmzSuggestionService;
import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.suggestion.ApplySuggestionValidator;
import com.atlassian.bitbucket.internal.suggestion.DefaultSuggestionService;
import com.atlassian.bitbucket.internal.suggestion.InternalSuggestionService;
import com.atlassian.bitbucket.internal.suggestion.MultilineSuggestionValidator;
import com.atlassian.bitbucket.internal.suggestion.SuggestionCommentEventListener;
import com.atlassian.bitbucket.internal.suggestion.SuggestionDriftCalculator;
import com.atlassian.bitbucket.internal.suggestion.dao.HibernateSuggestionGroupDao;
import com.atlassian.bitbucket.internal.suggestion.dao.SuggestionGroupDao;
import com.atlassian.bitbucket.internal.suggestion.parser.CommonMarkSuggestionParser;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StorageService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.comment.CommentDao;
import com.atlassian.stash.internal.pull.comment.CommentUpdateProcessor;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class SuggestionWiring {
    @Bean
    public SuggestionCommentEventListener suggestionCommentEventListener(FeatureManager featureManager, InternalSuggestionService service) {
        return new SuggestionCommentEventListener(featureManager, service);
    }

    @AvailableToPlugins(value=DmzSuggestionService.class)
    @Bean
    public InternalSuggestionService suggestionService(CommentUpdateProcessor commentUpdateProcessor, ContentService contentService, SuggestionGroupDao dao, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, CommonMarkSuggestionParser parser, StorageService storageService, @Value(value="${pullrequest.suggestions.commit-author}") String suggestionAuthor, MultilineSuggestionValidator multilineSuggestionValidator, SuggestionDriftCalculator suggestionDriftCalculator, DmzThrottleService throttleService, PlatformTransactionManager transactionManager, ApplySuggestionValidator validator) {
        return new DefaultSuggestionService(commentUpdateProcessor, contentService, dao, eventPublisher, featureManager, i18nService, multilineSuggestionValidator, parser, storageService, suggestionAuthor, suggestionDriftCalculator, throttleService, transactionManager, validator);
    }

    @Bean
    ApplySuggestionValidator applySuggestionValidator(CommentDao commentDao, I18nService i18nService, CommonMarkSuggestionParser parser, PermissionService permissionService, SuggestionGroupDao suggestionGroupDao) {
        return new ApplySuggestionValidator(commentDao, i18nService, parser, permissionService, suggestionGroupDao);
    }

    @Bean
    CommonMarkSuggestionParser commonMarkSuggestionParser() {
        return new CommonMarkSuggestionParser();
    }

    @Bean
    MultilineSuggestionValidator multilineSuggestionSpanValidator(I18nService i18nService, ScmService scmService) {
        return new MultilineSuggestionValidator(i18nService, scmService);
    }

    @Bean
    SuggestionDriftCalculator suggestionDriftCalculator(I18nService i18nService, ScmService scmService) {
        return new SuggestionDriftCalculator(i18nService, scmService);
    }

    @Bean
    SuggestionGroupDao suggestionDao(SessionFactory sessionFactory) {
        return new HibernateSuggestionGroupDao(sessionFactory);
    }
}

