/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableTableHiLoGenerator
extends SequenceStyleGenerator {
    public static final String MAX_LO = "max_lo";
    private static final Logger log = LoggerFactory.getLogger(ResettableTableHiLoGenerator.class);
    private long hi;
    private int lo;
    private int maxLo;
    private Class<?> returnClass;

    public void configure(Type type, Properties params, ServiceRegistry serviceRegistry) {
        Properties props = new Properties();
        props.setProperty("force_table_use", "true");
        props.setProperty("sequence_name", "hibernate_unique_key");
        props.setProperty("value_column", "next_hi");
        props.putAll((Map<?, ?>)params);
        super.configure(type, props, serviceRegistry);
        this.maxLo = ConfigurationHelper.getInt((String)MAX_LO, (Map)props, (int)Short.MAX_VALUE);
        this.lo = this.maxLo + 1;
        this.returnClass = type.getReturnedClass();
    }

    public synchronized Serializable generate(SharedSessionContractImplementor session, Object obj) throws HibernateException {
        if (this.lo > this.maxLo) {
            long hival = ((Number)super.generate(session, obj)).longValue();
            this.lo = 1;
            this.hi = hival * (long)(this.maxLo + 1);
            log.debug("new hi value: " + hival);
        }
        return IdentifierGeneratorHelper.getIntegralDataTypeHolder(this.returnClass).initialize(this.hi + (long)this.lo++).makeValue();
    }

    public int getMaxLo() {
        return this.maxLo;
    }

    public synchronized void reset() {
        this.lo = this.maxLo + 1;
    }

    public String[] sqlCreateStrings(Dialect dialect) {
        String[] createTableStatements = super.sqlCreateStrings(dialect);
        for (int i = 0; i < createTableStatements.length; ++i) {
            String createTableStatement = createTableStatements[i];
            if (!createTableStatement.startsWith(dialect.getCreateTableString())) continue;
            createTableStatements[i] = createTableStatement + dialect.getTableTypeString();
            break;
        }
        return createTableStatements;
    }
}

