/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.batching;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;

public class CriteriaBatchedInClauseHelper<S> {
    private final Class<S> criteriaClass;
    private final String inClauseParameterName;
    private final int batchSize;
    private final Predicate<S> predicate;

    public CriteriaBatchedInClauseHelper(Class<S> criteriaClass, String inClauseParameterName, int batchSize, Predicate<S> predicate) {
        this.criteriaClass = criteriaClass;
        this.inClauseParameterName = inClauseParameterName;
        this.batchSize = batchSize;
        this.predicate = predicate;
    }

    public <T> List<S> executeAndCollect(Session session, Iterable<T> inClauseObjects, Consumer<Criteria> criteriaConsumer) {
        ImmutableList.Builder allResultsBuilder = ImmutableList.builder();
        for (List subList : Iterables.partition(inClauseObjects, (int)this.batchSize)) {
            Criteria criteria = session.createCriteria(this.criteriaClass);
            criteria.add(Restrictions.in((String)this.inClauseParameterName, (Collection)subList));
            criteriaConsumer.accept(criteria);
            for (Object object : criteria.list()) {
                if (this.predicate.test(object)) {
                    allResultsBuilder.add(object);
                    continue;
                }
                return allResultsBuilder.build();
            }
        }
        return allResultsBuilder.build();
    }
}

