/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.batching;

import com.atlassian.hibernate.extras.batching.CriteriaBatchedInClauseHelper;
import com.google.common.base.Preconditions;
import java.util.function.Predicate;

public class CriteriaBatchedInClauseHelperBuilder<S> {
    protected static final int ORACLE_IN_CLAUSE_LIMIT = 1000;
    private static final Predicate DEFAULT_PREDICATE = o -> true;
    private final Class<S> criteriaClass;
    private String inClauseParameterName;
    protected int batchSize = 1000;
    private Predicate<S> predicate = DEFAULT_PREDICATE;

    protected CriteriaBatchedInClauseHelperBuilder(Class<S> criteriaClass) {
        this.criteriaClass = criteriaClass;
    }

    public CriteriaBatchedInClauseHelperBuilder<S> withParameter(String parameter) {
        this.inClauseParameterName = parameter;
        return this;
    }

    public CriteriaBatchedInClauseHelperBuilder<S> withBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public CriteriaBatchedInClauseHelperBuilder<S> withPredicate(Predicate<S> predicate) {
        this.predicate = predicate;
        return this;
    }

    public CriteriaBatchedInClauseHelper<S> build() {
        Preconditions.checkNotNull(this.criteriaClass);
        Preconditions.checkNotNull((Object)this.inClauseParameterName);
        Preconditions.checkNotNull(this.predicate);
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"Batch size must be larger than 0");
        return new CriteriaBatchedInClauseHelper<S>(this.criteriaClass, this.inClauseParameterName, this.batchSize, this.predicate);
    }

    public static <S> CriteriaBatchedInClauseHelperBuilder<S> of(Class<S> criteriaClass) {
        return new CriteriaBatchedInClauseHelperBuilder<S>(criteriaClass);
    }
}

