/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.hql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.spi.id.AbstractTableBasedBulkIdHandler;
import org.hibernate.hql.spi.id.IdTableInfo;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Alias;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.JoinType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinTableBasedDeleteHandlerImpl
extends AbstractTableBasedBulkIdHandler
implements MultiTableBulkIdStrategy.DeleteHandler {
    private static final Logger log = LoggerFactory.getLogger(JoinTableBasedDeleteHandlerImpl.class);
    private static final String DELETE_SUFFIX = "_0";
    private final List<String> deletes;
    private final String idInsertSelect;
    private final List<ParameterSpecification> idSelectParameterSpecifications;
    private final Queryable targetedPersister;

    public JoinTableBasedDeleteHandlerImpl(SessionFactoryImplementor factory, HqlSqlWalker walker, IdTableInfo idTableInfo) {
        super(factory, walker);
        DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        this.targetedPersister = fromElement.getQueryable();
        String bulkTargetAlias = fromElement.getTableAlias();
        AbstractTableBasedBulkIdHandler.ProcessedWhereClause processedWhereClause = this.processWhereClause(deleteStatement.getWhereClause());
        this.idSelectParameterSpecifications = processedWhereClause.getIdSelectParameterSpecifications();
        this.idInsertSelect = this.generateIdInsertSelect(bulkTargetAlias, idTableInfo, processedWhereClause);
        log.trace("Generated ID-INSERT-SELECT SQL (joined-multi-table delete) : {0}", (Object)this.idInsertSelect);
        this.deletes = new ArrayList<String>();
        for (Type type : this.targetedPersister.getPropertyTypes()) {
            if (!type.isCollectionType()) continue;
            CollectionType collectionType = (CollectionType)type;
            QueryableCollection collectionPersister = (QueryableCollection)factory.getMetamodel().collectionPersister(collectionType.getRole());
            if (!collectionPersister.isManyToMany()) continue;
            this.deletes.add(this.generateDelete(collectionPersister.getTableName(), collectionPersister.getKeyColumnNames(), idTableInfo));
        }
        String[] tableNames = this.targetedPersister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.targetedPersister.getContraintOrderedTableKeyColumnClosure();
        for (int i = 0; i < tableNames.length; ++i) {
            this.deletes.add(this.generateDelete(tableNames[i], columnNames[i], idTableInfo));
        }
    }

    public Queryable getTargetedQueryable() {
        return this.targetedPersister;
    }

    public String[] getSqlStatements() {
        return this.deletes.toArray(new String[this.deletes.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(SharedSessionContractImplementor session, QueryParameters queryParameters) {
        this.prepareForUse(this.targetedPersister, session);
        try {
            int resultCount;
            PreparedStatement ps = null;
            try {
                try {
                    ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    int pos = 1;
                    for (ParameterSpecification parameterSpecification : this.idSelectParameterSpecifications) {
                        pos += parameterSpecification.bind(ps, queryParameters, session, pos);
                    }
                    resultCount = session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                }
                finally {
                    if (ps != null) {
                        session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release((Statement)ps);
                        session.getJdbcCoordinator().afterStatementExecution();
                    }
                }
            }
            catch (SQLException e) {
                throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (String delete : this.deletes) {
                try {
                    ps = session.getJdbcCoordinator().getStatementPreparer().prepareStatement(delete, false);
                    session.getJdbcCoordinator().getResultSetReturn().executeUpdate(ps);
                }
                finally {
                    if (ps == null) continue;
                    session.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release((Statement)ps);
                    session.getJdbcCoordinator().afterStatementExecution();
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.releaseFromUse(this.targetedPersister, session);
        }
    }

    private static String[] prefixWithAlias(String[] original, String alias) {
        String fullPrefix = alias + ".";
        String[] aliased = new String[original.length];
        for (int i = 0; i < original.length; ++i) {
            aliased[i] = fullPrefix + original[i];
        }
        return aliased;
    }

    private String generateDelete(String tableName, String[] columnNames, IdTableInfo idTableInfo) {
        Alias alias = new Alias(DELETE_SUFFIX);
        String deleteTableAlias = alias.toAliasString(tableName);
        String tempIdTable = idTableInfo.getQualifiedIdTableName();
        String tempIdTableAlias = alias.toAliasString(tempIdTable);
        String[] aliasedColumnNames = JoinTableBasedDeleteHandlerImpl.prefixWithAlias(columnNames, deleteTableAlias);
        JoinFragment deleteJoin = this.factory().getJdbcServices().getDialect().createOuterJoinFragment();
        deleteJoin.addJoin(tempIdTable, tempIdTableAlias, aliasedColumnNames, this.targetedPersister.getIdentifierColumnNames(), JoinType.INNER_JOIN);
        return "delete " + deleteTableAlias + " from " + tableName + " " + deleteTableAlias + " " + deleteJoin.toFromFragmentString();
    }
}

