/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hibernate.extras.hql;

import com.atlassian.hibernate.extras.hql.JoinTableBasedDeleteHandlerImpl;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.spi.MetadataBuildingOptions;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.tree.DeleteStatement;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.spi.id.IdTableInfo;
import org.hibernate.hql.spi.id.IdTableSupport;
import org.hibernate.hql.spi.id.IdTableSupportStandardImpl;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.hql.spi.id.local.AfterUseAction;
import org.hibernate.hql.spi.id.local.HelperAccessor;
import org.hibernate.hql.spi.id.local.IdTableInfoImpl;
import org.hibernate.hql.spi.id.local.LocalTemporaryTableBulkIdStrategy;
import org.hibernate.persister.entity.Queryable;

public class JoinTemporaryTableBulkIdStrategy
extends LocalTemporaryTableBulkIdStrategy {
    private final AfterUseAction afterUseAction;
    private TempTableDdlTransactionHandling ddlTransactionHandling;

    public JoinTemporaryTableBulkIdStrategy() {
        this((IdTableSupport)new IdTableSupportStandardImpl(){

            public String getCreateIdTableCommand() {
                return "create temporary table if not exists";
            }

            public String getDropIdTableCommand() {
                return "drop temporary table";
            }
        }, AfterUseAction.DROP, TempTableDdlTransactionHandling.NONE);
    }

    public JoinTemporaryTableBulkIdStrategy(IdTableSupport idTableSupport, AfterUseAction afterUseAction, TempTableDdlTransactionHandling ddlTransactionHandling) {
        super(idTableSupport, afterUseAction, ddlTransactionHandling);
        this.afterUseAction = afterUseAction;
        this.ddlTransactionHandling = ddlTransactionHandling;
    }

    public MultiTableBulkIdStrategy.DeleteHandler buildDeleteHandler(SessionFactoryImplementor factory, HqlSqlWalker walker) {
        DeleteStatement updateStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        Queryable targetedPersister = fromElement.getQueryable();
        final IdTableInfoImpl tableInfo = (IdTableInfoImpl)this.getIdTableInfo(targetedPersister);
        return new JoinTableBasedDeleteHandlerImpl(factory, walker, (IdTableInfo)tableInfo){

            protected void prepareForUse(Queryable persister, SharedSessionContractImplementor session) {
                HelperAccessor.createTempTable(tableInfo, JoinTemporaryTableBulkIdStrategy.this.ddlTransactionHandling, session);
            }

            protected void releaseFromUse(Queryable persister, SharedSessionContractImplementor session) {
                HelperAccessor.releaseTempTable(tableInfo, JoinTemporaryTableBulkIdStrategy.this.afterUseAction, JoinTemporaryTableBulkIdStrategy.this.ddlTransactionHandling, session);
            }
        };
    }

    protected void initialize(MetadataBuildingOptions buildingOptions, SessionFactoryOptions sessionFactoryOptions) {
        super.initialize(buildingOptions, sessionFactoryOptions);
        if (this.ddlTransactionHandling == null) {
            this.ddlTransactionHandling = sessionFactoryOptions.getTempTableDdlTransactionHandling();
        }
    }
}

