/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.annotations.security.UnrestrictedAccess;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.util.Arrays;

@UnrestrictedAccess
public class CacheControlOverrideFilter
implements Filter {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final long DEFAULT_MAX_AGE = 1800L;
    private final boolean enabled = System.getProperty("events.remote.cachecontrol.disabled", "false").equalsIgnoreCase("false");
    private final long maxAgeInSeconds = CacheControlOverrideFilter.getMaxAgeProperty();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.addHeader(CACHE_CONTROL, String.join((CharSequence)", ", Arrays.asList("max-age=" + this.maxAgeInSeconds, "must-revalidate", "private")));
            chain.doFilter(request, (ServletResponse)new HttpServletResponseWrapper(this, httpResponse){

                public void addHeader(String name, String value) {
                    if (!CacheControlOverrideFilter.CACHE_CONTROL.equals(name)) {
                        super.addHeader(name, value);
                    }
                }
            });
        } else {
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    private static long getMaxAgeProperty() {
        String prop = System.getProperty("events.remote.cachecontrol.maxage", Long.toString(1800L));
        try {
            return Long.parseLong(prop);
        }
        catch (NumberFormatException ignored) {
            return 1800L;
        }
    }
}

