/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.RemoteEventProducer;
import com.atlassian.event.remote.RemoteEventProducerRegistrar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteEventProducerRegistrar
implements RemoteEventProducerRegistrar {
    private static final Logger log = LoggerFactory.getLogger(DefaultRemoteEventProducerRegistrar.class);
    private final Map<RemoteEventProducer, Set<Class<? extends RemoteEvent>>> registeredProducers = new HashMap<RemoteEventProducer, Set<Class<? extends RemoteEvent>>>();
    private volatile Set<Class> registeredEvents;

    public Iterable<RemoteEvent> filterApplink(String applinkId, Iterable<RemoteEvent> events) {
        HashSet eventsToSend = new HashSet();
        this.registeredProducers.forEach((producer, eventClasses) -> {
            if (producer.getApplinkFilter().shouldFilter(applinkId)) {
                log.debug("Producer [{}] has configured the following classes for filtering {}", (Object)producer.getClass().getSimpleName(), eventClasses);
            } else {
                eventsToSend.addAll(eventClasses);
            }
        });
        HashSet<RemoteEvent> filter = new HashSet<RemoteEvent>();
        HashSet<RemoteEvent> send = new HashSet<RemoteEvent>();
        for (RemoteEvent e2 : events) {
            if (eventsToSend.contains(e2.getClass())) {
                send.add(e2);
                continue;
            }
            filter.add(e2);
        }
        if (log.isDebugEnabled() && !filter.isEmpty()) {
            log.debug("Filtering applied for [{}] events with following classes {}", (Object)filter.size(), (Object)filter.stream().map(e -> e.getClass().getSimpleName()).collect(Collectors.joining(" ")));
        }
        return send;
    }

    public boolean isRegistered(RemoteEvent event) {
        for (Class clazz : this.getRegisteredEvents()) {
            if (!clazz.isAssignableFrom(event.getClass())) continue;
            return true;
        }
        return false;
    }

    public Set<String> publishedCapabilities() {
        return this.getRegisteredEvents().stream().map(RemoteEvent::getCapabilities).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(RemoteEventProducer producer) {
        Map<RemoteEventProducer, Set<Class<? extends RemoteEvent>>> map = this.registeredProducers;
        synchronized (map) {
            Set events = StreamSupport.stream(producer.produces().spliterator(), false).collect(Collectors.toSet());
            if (this.registeredProducers.put(producer, events) == null) {
                this.registeredEvents = null;
            }
        }
        log.debug("Registered producer: {}", (Object)producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(RemoteEventProducer producer) {
        Map<RemoteEventProducer, Set<Class<? extends RemoteEvent>>> map = this.registeredProducers;
        synchronized (map) {
            if (this.registeredProducers.remove(producer) != null) {
                this.registeredEvents = null;
            }
        }
        log.debug("Unregistered producer: {}", (Object)producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll() {
        Map<RemoteEventProducer, Set<Class<? extends RemoteEvent>>> map = this.registeredProducers;
        synchronized (map) {
            this.registeredProducers.clear();
            this.registeredEvents = null;
        }
        log.debug("Unregistered all producers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class> getRegisteredEvents() {
        if (this.registeredEvents == null) {
            Map<RemoteEventProducer, Set<Class<? extends RemoteEvent>>> map = this.registeredProducers;
            synchronized (map) {
                this.registeredEvents = this.registeredProducers.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            }
        }
        return this.registeredEvents;
    }
}

