/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.event.remote.CoalescingRemoteEvent;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.impl.cache.EventSubscriptionCapabilities;
import com.atlassian.event.remote.impl.cache.LinkedAppEventCapabilities;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteEventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventDispatcher.class);
    private final ApplicationLinkService applicationLinks;
    private final LinkedApplicationCapabilities capabilities;
    private final JsonUtil eventSerializer;
    private final EventSubscriptionCapabilities eventSubscriptions;
    private final HttpUtil httpUtil;
    private final RequestAuthorizor requestAuthorizor;

    @Autowired
    public RemoteEventDispatcher(@ComponentImport ApplicationLinkService applicationLinks, @ComponentImport LinkedApplicationCapabilities capabilities, @ComponentImport JsonUtil eventSerializer, EventSubscriptionCapabilities eventSubscriptions, HttpUtil httpUtil, @ComponentImport RequestAuthorizor requestAuthorizor) {
        this.applicationLinks = applicationLinks;
        this.capabilities = capabilities;
        this.eventSerializer = eventSerializer;
        this.eventSubscriptions = eventSubscriptions;
        this.httpUtil = httpUtil;
        this.requestAuthorizor = requestAuthorizor;
        log.debug("Created with capabilities = {} and event subscriptions = {}", (Object)capabilities, (Object)eventSubscriptions);
    }

    public void dispatch(String appLinkId, Iterable<RemoteEvent> events) {
        try {
            ApplicationLink appLink = this.applicationLinks.getApplicationLink(new ApplicationId(appLinkId));
            if (appLink == null) {
                log.debug("Attempt to dispatch {} to unknown app link {}", events, (Object)appLinkId);
            }
            this.dispatchToAppLink(appLink, events);
            log.debug("Successfully dispatched events {} to app link {}", events, (Object)appLinkId);
        }
        catch (TypeNotInstalledException e) {
            log.debug("ApplicationLink's ApplicationType is not currently installed for app link {}", (Object)appLinkId);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.error(String.format("Error dispatching %s to %s", events, appLinkId), (Throwable)e);
            throw e;
        }
    }

    public Set<String> lookup(RemoteEvent event) {
        List eventCapabilities = RemoteEvent.getCapabilities((Object)event);
        Set capableApps = Stream.concat(eventCapabilities.stream().flatMap(capability -> this.eventSubscriptions.capableOf((String)capability).stream().map(LinkedAppEventCapabilities::getApp)), eventCapabilities.stream().flatMap(capability -> this.capabilities.capableOf(capability).stream())).collect(Collectors.toSet());
        log.debug("RemoteEvent {} consumable by {}", (Object)event, capableApps);
        return capableApps.stream().map(LinkedAppWithCapabilities::getApplicationLinkId).collect(Collectors.toSet());
    }

    private List<RemoteEvent> coalesceEventList(Iterable<RemoteEvent> events) {
        HashMap coalescedEvents = new HashMap();
        LinkedList<RemoteEvent> returnedEvents = new LinkedList<RemoteEvent>();
        for (RemoteEvent event : events) {
            if (event instanceof CoalescingRemoteEvent) {
                CoalescingRemoteEvent coalescingRemoteEvent = (CoalescingRemoteEvent)event;
                Class<?> clazz = event.getClass();
                if (coalescedEvents.containsKey(clazz)) {
                    CoalescingRemoteEvent oldEvent = (CoalescingRemoteEvent)coalescedEvents.get(clazz);
                    coalescedEvents.put(clazz, oldEvent.coalesce(coalescingRemoteEvent));
                    continue;
                }
                coalescedEvents.put(clazz, coalescingRemoteEvent);
                continue;
            }
            returnedEvents.addFirst(event);
        }
        returnedEvents.addAll(0, coalescedEvents.values());
        return returnedEvents;
    }

    private ApplicationLinkRequest createRequest(ApplicationLink appLink, String url) throws CredentialsRequiredException {
        return this.requestAuthorizor.getAuthorizedRequestFactory(appLink).createRequest(Request.MethodType.POST, url);
    }

    private void dispatchToAppLink(ApplicationLink appLink, Iterable<RemoteEvent> events) {
        log.debug("Dispatching events {} to app link {}", events, (Object)appLink);
        HashMap<String, List> batches = new HashMap<String, List>();
        for (RemoteEvent event : this.coalesceEventList(events)) {
            for (String capability : RemoteEvent.getCapabilities((Object)event)) {
                for (String url2 : this.getTargetUrls(appLink.getId().get(), capability)) {
                    List eventList2 = batches.computeIfAbsent(url2, key -> new ArrayList());
                    eventList2.add(event);
                }
            }
        }
        log.debug("Found dispatch batches: {}", batches);
        batches.forEach((url, eventList) -> {
            log.debug("Sending {} event(s) to {}", (Object)eventList.size(), url);
            String body = null;
            String appLinkUrl = null;
            try {
                body = this.eventSerializer.write(eventList.size() == 1 ? eventList.get(0) : eventList);
                appLinkUrl = this.getAppLinkUrl(appLink, (String)url);
                ApplicationLinkRequest request = this.createRequest(appLink, (String)url);
                this.dispatchRequest(request, appLinkUrl, body);
            }
            catch (Exception e) {
                this.logDispatchError(body, appLinkUrl, e);
            }
        });
    }

    private void dispatchRequest(ApplicationLinkRequest request, String url, String body) {
        UUID uuid = UUID.randomUUID();
        request.setConnectionTimeout(Integer.getInteger("events.remote.ratelimit.timeout", 3000).intValue());
        request.setHeader("Content-Type", "application/json");
        request.setHeader("X-request-id", uuid.toString());
        request.setRequestBody(body);
        if (log.isDebugEnabled()) {
            log.debug(String.format("Dispatching remote event %s with request id %s to %s", body, uuid, url));
        }
        try {
            request.execute(response -> log.debug(String.format("Request %s to %s returned (%b, %d, %s)", uuid, url, response.isSuccessful(), response.getStatusCode(), response.getStatusText())));
        }
        catch (ResponseException e) {
            log.debug(String.format("Request %s to %s returned error %s", uuid, url, e.getMessage()));
        }
    }

    private Set<String> getTargetUrls(String appLinkId, String capability) {
        return Stream.concat(this.eventSubscriptions.capableOf(capability).stream().filter(e -> e.getApp().getApplicationLinkId().equals(appLinkId)).map(e -> e.getCapabilities().get(capability)), this.capabilities.capableOf(capability).stream().filter(linkedApp -> linkedApp.getApplicationLinkId().equals(appLinkId)).map(linkedApp -> linkedApp.getCapabilityUrl(capability)).filter(Objects::nonNull)).collect(Collectors.toSet());
    }

    private String getAppLinkUrl(ApplicationLink appLink, String suffix) throws URISyntaxException {
        return this.httpUtil.getUrl(appLink.getRpcUrl().toASCIIString(), suffix).toASCIIString();
    }

    private void logDispatchError(String body, String url, Exception ex) {
        log.warn(String.format("Failed to send events %s to %s with error %s", body, url, ex.getMessage()), (Throwable)(log.isDebugEnabled() ? ex : null));
    }
}

