/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl;

import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.event.remote.RemoteEvent;
import com.atlassian.event.remote.impl.DefaultRemoteEventProducerRegistrar;
import com.atlassian.event.remote.impl.RemoteEventDispatcher;
import com.atlassian.event.remote.impl.ratelimit.BatchRateLimiter;
import com.atlassian.event.remote.impl.ratelimit.BatchRateLimiterDispatcher;
import com.atlassian.event.remote.impl.util.PropertiesParser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.util.concurrent.ThreadFactories;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemoteEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventListener.class);
    private final EventPublisher eventRegistrar;
    private final ScheduledExecutorService executorService;
    private final BatchRateLimiterDispatcher<String, RemoteEvent> limiter;
    private final boolean producerEnabled;
    private final DefaultRemoteEventProducerRegistrar producerRegistrar;

    @Autowired
    public RemoteEventListener(RemoteEventDispatcher dispatcher, @ComponentImport EventPublisher eventRegistrar, DefaultRemoteEventProducerRegistrar producerRegistrar) {
        this.eventRegistrar = eventRegistrar;
        this.producerRegistrar = producerRegistrar;
        PropertiesParser properties = new PropertiesParser(System.getProperties(), "events.remote.");
        this.producerEnabled = properties.parseBoolean("produce.enabled", true);
        this.executorService = Executors.newScheduledThreadPool(properties.parseInteger("ratelimit.core.threads", 3), ThreadFactories.namedThreadFactory((String)"events.remote.ratelimit.threads", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
        Function<String, BatchRateLimiter> newBatchRateLimiter = key -> new BatchRateLimiter((String)key, (applinkId, events) -> {
            dispatcher.dispatch((String)applinkId, producerRegistrar.filterApplink((String)applinkId, (Iterable<RemoteEvent>)events));
            return null;
        }, this.executorService, Duration.ofMillis(properties.parseInteger("ratelimit.fillInterval", 1000)), properties.parseInteger("ratelimit.maxTokens", 10), properties.parseInteger("ratelimit.queueSize", 10000), properties.parseInteger("ratelimit.maxBatchSize", 1000));
        this.limiter = new BatchRateLimiterDispatcher<String, RemoteEvent>(newBatchRateLimiter, dispatcher::lookup);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventRegistrar.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventRegistrar.unregister((Object)this);
        this.executorService.shutdownNow();
    }

    @EventListener
    public void onApplicationLinkDeleted(ApplicationLinkDeletedEvent event) {
        this.limiter.remove(event.getApplicationId().get());
    }

    @EventListener
    public void onRemoteEvent(RemoteEvent event) {
        if (!this.producerEnabled) {
            log.debug("Producer not enabled; ignoring RemoteEvent {}", (Object)event);
            return;
        }
        if (event.fromRemote()) {
            log.debug("Ignoring non-local RemoteEvent {}", (Object)event);
            return;
        }
        if (!this.producerRegistrar.isRegistered(event)) {
            log.error("Got unregistered RemoteEvent {}", (Object)event);
            return;
        }
        log.debug("Queueing RemoteEvent {}", (Object)event);
        Set<String> overflowedKeys = this.limiter.queueForDispatch(event);
        if (overflowedKeys.isEmpty()) {
            log.debug("Batch size not exceeded for {}", (Object)event);
        } else {
            log.warn("Batch size exceeded for {} with {}", overflowedKeys, (Object)event);
        }
    }
}

