/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.cache;

import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.event.remote.impl.cache.CapabilitiesSubscriptionResponse;
import com.atlassian.event.remote.impl.cache.CapabilitiesSubscriptionService;
import com.atlassian.event.remote.impl.cache.LinkedAppEventCapabilities;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.ExpiringValue;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CapabilitiesCacheLoader
implements CacheLoader<String, LinkedAppEventCapabilities>,
DisposableBean {
    public static final String REMOTE_EVENT_CONSUMER_CAPABILITY = "atlassian-remote-event-consumer";
    private final LinkedApplicationCapabilities applicationCapabilities;
    private final ExecutorService executor;
    private final CapabilitiesSubscriptionService capabilitiesSubscriptionService;
    private final HttpUtil httpUtil;

    @Autowired
    public CapabilitiesCacheLoader(@ComponentImport LinkedApplicationCapabilities applicationCapabilities, CapabilitiesSubscriptionService capabilitiesSubscriptionService, @ComponentImport HttpUtil httpUtil) {
        this.applicationCapabilities = applicationCapabilities;
        this.capabilitiesSubscriptionService = capabilitiesSubscriptionService;
        this.httpUtil = httpUtil;
        this.executor = Executors.newSingleThreadExecutor(ThreadFactories.namedThreadFactory((String)"RemoteEvents CapabilitiesCacheLoader"));
    }

    public Set<String> getAllKeys() {
        return this.applicationCapabilities.capableOf(REMOTE_EVENT_CONSUMER_CAPABILITY).stream().map(LinkedAppWithCapabilities::getApplicationLinkId).collect(Collectors.toUnmodifiableSet());
    }

    public Future<ExpiringValue<LinkedAppEventCapabilities>> loadValueFuture(String key) {
        try {
            LinkedAppWithCapabilities app = this.getLinkedApp(key);
            return this.executor.submit(() -> this.getLinkedAppCapabilities(app));
        }
        catch (RuntimeException e) {
            CompletableFuture<ExpiringValue<LinkedAppEventCapabilities>> failing = new CompletableFuture<ExpiringValue<LinkedAppEventCapabilities>>();
            failing.completeExceptionally(e);
            return failing;
        }
    }

    private ExpiringValue<LinkedAppEventCapabilities> getLinkedAppCapabilities(LinkedAppWithCapabilities app) throws TypeNotInstalledException, IOException {
        CapabilitiesSubscriptionResponse response = this.capabilitiesSubscriptionService.getCapabilitiesSubscription(this.httpUtil.getCapabilityUrl(app, REMOTE_EVENT_CONSUMER_CAPABILITY));
        return new ExpiringValue((Object)new LinkedAppEventCapabilities(app, response.capabilities), response.staleAfterInMillis, response.expiredAfterMillis);
    }

    private LinkedAppWithCapabilities getLinkedApp(String key) {
        return this.applicationCapabilities.capableOf(REMOTE_EVENT_CONSUMER_CAPABILITY).stream().filter(input -> key.equals(input.getApplicationLinkId())).findFirst().orElse(null);
    }

    public void destroy() {
        this.executor.shutdownNow();
    }
}

