/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.cache;

import com.atlassian.event.remote.impl.cache.CapabilitiesSubscriptionResponse;
import com.atlassian.event.remote.internal.http.HttpRequestService;
import com.atlassian.event.remote.internal.http.ResponseBodyHandler;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CapabilitiesSubscriptionService {
    private final HttpRequestService httpRequestService;
    private final JsonUtil jsonUtil;
    private final CapabilitiesSubscriptionHandler subscriptionHandler;

    @Autowired
    public CapabilitiesSubscriptionService(@ComponentImport HttpRequestService httpRequestService, @ComponentImport JsonUtil jsonUtil) {
        this.httpRequestService = httpRequestService;
        this.jsonUtil = jsonUtil;
        this.subscriptionHandler = new CapabilitiesSubscriptionHandler();
    }

    public CapabilitiesSubscriptionResponse getCapabilitiesSubscription(String url) throws IOException {
        return (CapabilitiesSubscriptionResponse)this.httpRequestService.get(url, (ResponseBodyHandler)this.subscriptionHandler);
    }

    private class CapabilitiesSubscriptionHandler
    implements ResponseBodyHandler<CapabilitiesSubscriptionResponse> {
        private CapabilitiesSubscriptionHandler() {
        }

        public CapabilitiesSubscriptionResponse handle(String body, long staleAfterInMillis, long expiredAfterMillis) throws IOException {
            Map capabilities = Collections.emptyMap();
            if (body != null && !body.isEmpty()) {
                capabilities = (Map)CapabilitiesSubscriptionService.this.jsonUtil.read(body, Map.class);
            }
            return new CapabilitiesSubscriptionResponse(capabilities, staleAfterInMillis, expiredAfterMillis);
        }
    }
}

