/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.cache;

import com.atlassian.event.remote.impl.cache.CapabilitiesCacheLoader;
import com.atlassian.event.remote.impl.cache.LinkedAppEventCapabilities;
import com.atlassian.failurecache.Cache;
import com.atlassian.failurecache.CacheFactory;
import com.atlassian.failurecache.CacheLoader;
import com.atlassian.failurecache.failures.ExponentialBackOffFailureCache;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.util.concurrent.ThreadFactories;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventSubscriptionCapabilities
implements InitializingBean,
DisposableBean,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(EventSubscriptionCapabilities.class);
    private static final Duration INITIAL_DELAY = Duration.ofSeconds(5L);
    private static final Duration DELAY = Duration.ofSeconds(30L);
    private static final double DEFAULT_BACK_OFF_RATE = Integer.getInteger("navlink.failurecache.backoff", 2).intValue();
    private static final long DEFAULT_INITIAL_EXPIRY_MS = Long.getLong("navlink.failurecache.initialexpiryMs", TimeUnit.SECONDS.toMillis(1L));
    private static final int DEFAULT_MAX_ENTRIES = Integer.getInteger("navlink.failurecache.maxEntries", 1000);
    private static final long DEFAULT_MAX_EXPIRY_MS = Long.getLong("navlink.failurecache.maxExpiryMs", TimeUnit.MINUTES.toMillis(1L));
    private final Cache<LinkedAppEventCapabilities> cache;
    private final ScheduledExecutorService executorService;
    private volatile ScheduledFuture scheduler;

    @Autowired
    public EventSubscriptionCapabilities(@ComponentImport CacheFactory cacheFactory, CapabilitiesCacheLoader capabilitiesCacheLoader) {
        ExponentialBackOffFailureCache failureCache = new ExponentialBackOffFailureCache.Builder().backOffRate(DEFAULT_BACK_OFF_RATE).initialExpiry(DEFAULT_INITIAL_EXPIRY_MS, TimeUnit.MILLISECONDS).maxEntries(DEFAULT_MAX_ENTRIES).maxExpiry(DEFAULT_MAX_EXPIRY_MS, TimeUnit.MILLISECONDS).build();
        this.cache = cacheFactory.createExpirationDateBasedCache((CacheLoader)capabilitiesCacheLoader, failureCache);
        this.executorService = Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory((String)"EventSubscriptionCapabilities"));
    }

    public void afterPropertiesSet() throws Exception {
        this.scheduler = this.executorService.scheduleWithFixedDelay(this, INITIAL_DELAY.toMillis(), DELAY.toMillis(), TimeUnit.MILLISECONDS);
    }

    public Set<LinkedAppEventCapabilities> capableOf(String capability) {
        return Set.copyOf(StreamSupport.stream(this.cache.getValues().spliterator(), false).filter(app -> app.getCapabilities().containsKey(capability)).collect(Collectors.toUnmodifiableSet()));
    }

    public void clear() {
        try {
            this.cache.clear();
        }
        catch (RuntimeException e) {
            log.debug("Failed to clear linked application capabilities cache", (Throwable)e);
        }
    }

    public void destroy() throws Exception {
        this.scheduler.cancel(true);
        this.executorService.shutdownNow();
        this.clear();
    }

    public void refresh() {
        try {
            this.cache.refresh();
        }
        catch (RuntimeException e) {
            log.debug("Failed to refresh linked application capabilities cache", (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.refresh();
    }
}

