/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.ratelimit;

import com.atlassian.event.remote.impl.ratelimit.TokenBasedRateLimiter;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRateLimiter<K, V> {
    private static final Logger log = LoggerFactory.getLogger(BatchRateLimiter.class);
    private final BiFunction<K, Iterable<V>, Void> dispatchBatch;
    private final ScheduledExecutorService executorService;
    private final K key;
    private final int maxBatchSize;
    private final BlockingQueue<V> queue;
    private final TokenBasedRateLimiter rateLimiter;
    private final Duration rateLimitPeriod;
    private volatile boolean isScheduled;

    public BatchRateLimiter(K key, BiFunction<K, Iterable<V>, Void> dispatchBatch, ScheduledExecutorService executorService, Duration rateLimitPeriod, long maxDispatchesPerPeriod, int queueSize, int maxBatchSize) {
        this.key = key;
        this.dispatchBatch = dispatchBatch;
        this.executorService = executorService;
        this.rateLimitPeriod = rateLimitPeriod;
        this.maxBatchSize = maxBatchSize;
        this.queue = new LinkedBlockingQueue<V>(queueSize);
        this.rateLimiter = new TokenBasedRateLimiter(rateLimitPeriod, maxDispatchesPerPeriod, System.currentTimeMillis());
    }

    public void destroy() {
        this.queue.clear();
    }

    public boolean isIdle() {
        long now = System.currentTimeMillis();
        return this.isEmpty() && this.rateLimiter.getLastExecutionScheduledTime() + this.rateLimitPeriod.toMillis() < now;
    }

    public boolean queue(V value) {
        boolean success = this.queue.offer(value);
        this.scheduleNewBatch();
        return success;
    }

    private void batchComplete() {
        this.isScheduled = false;
    }

    private void batchScheduled() {
        this.isScheduled = true;
    }

    private void dispatch() {
        try {
            Set<V> values = this.nextBatch();
            if (!values.isEmpty()) {
                this.dispatchBatch.apply(this.key, values);
            }
        }
        catch (Exception e) {
            log.error("Error occurred while dispatching remote event batch", (Throwable)e);
        }
        finally {
            this.batchComplete();
            this.scheduleNewBatch();
        }
    }

    private boolean isEmpty() {
        return this.queue.isEmpty();
    }

    private Set<V> nextBatch() {
        HashSet drained = new HashSet(Math.min(this.queue.size(), this.maxBatchSize));
        this.queue.drainTo(drained, this.maxBatchSize);
        return drained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNewBatch() {
        BatchRateLimiter batchRateLimiter = this;
        synchronized (batchRateLimiter) {
            if (this.shouldScheduleNewBatch()) {
                try {
                    long now = System.currentTimeMillis();
                    this.executorService.schedule(this::dispatch, this.rateLimiter.getNextExecution(now).toMillis(), TimeUnit.MILLISECONDS);
                    this.batchScheduled();
                }
                catch (Exception e) {
                    log.error("Failed to schedule remote event dispatch task", (Throwable)e);
                }
            }
        }
    }

    private boolean shouldScheduleNewBatch() {
        return !this.isEmpty() && !this.isScheduled;
    }
}

