/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.ratelimit;

import com.atlassian.event.remote.impl.ratelimit.BatchRateLimiter;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class BatchRateLimiterDispatcher<K, V> {
    private final Function<V, Iterable<K>> lookupKeys;
    private final Function<K, BatchRateLimiter<K, V>> newBatchRateLimiter;
    private final ConcurrentHashMap<K, BatchRateLimiter<K, V>> valuesToDispatch;

    public BatchRateLimiterDispatcher(Function<K, BatchRateLimiter<K, V>> newBatchRateLimiter, Function<V, Iterable<K>> lookupKeys) {
        this.newBatchRateLimiter = newBatchRateLimiter;
        this.lookupKeys = lookupKeys;
        this.valuesToDispatch = new ConcurrentHashMap();
    }

    public Set<K> queueForDispatch(V value) {
        HashSet<K> notDispatched = new HashSet<K>();
        Iterable<K> keys = this.lookupKeys.apply(value);
        for (K key : keys) {
            BatchRateLimiter<K, V> batchRateLimiter = this.valuesToDispatch.computeIfAbsent(key, this.newBatchRateLimiter);
            boolean dispatched = batchRateLimiter.queue(value);
            if (dispatched) continue;
            notDispatched.add(key);
        }
        this.cleanupUnusedValuesToDispatch();
        return notDispatched;
    }

    public Optional<BatchRateLimiter<K, V>> remove(K key) {
        Optional<BatchRateLimiter<K, V>> removedBatchRateLimiter = Optional.ofNullable(this.valuesToDispatch.remove(key));
        removedBatchRateLimiter.ifPresent(BatchRateLimiter::destroy);
        return removedBatchRateLimiter;
    }

    private void cleanupUnusedValuesToDispatch() {
        this.valuesToDispatch.entrySet().stream().filter(entry -> ((BatchRateLimiter)entry.getValue()).isIdle()).forEach(entry -> this.remove(entry.getKey()));
    }
}

