/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.ratelimit;

import java.time.Duration;

public class TokenBasedRateLimiter {
    private final long fillIntervalMillis;
    private final long maxTokens;
    private volatile long lastTokenRemovedTime;
    private volatile double tokenRatio;

    public TokenBasedRateLimiter(Duration fillInterval, long maxTokens, long lastTokenRemovedTime) {
        this.fillIntervalMillis = fillInterval.toMillis();
        this.maxTokens = maxTokens;
        this.lastTokenRemovedTime = lastTokenRemovedTime;
    }

    public long getLastExecutionScheduledTime() {
        return this.lastTokenRemovedTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration getNextExecution(long now) {
        TokenBasedRateLimiter tokenBasedRateLimiter = this;
        synchronized (tokenBasedRateLimiter) {
            this.tokenRatio = this.calcTokenRatio(now, 1);
            this.lastTokenRemovedTime = now;
            return this.nextExecute(now);
        }
    }

    private double calcTokenRatio(long now, int offset) {
        return (this.tokenRatio * (double)this.fillIntervalMillis + (double)offset) / (double)(this.fillIntervalMillis + now - this.lastTokenRemovedTime);
    }

    private Duration nextExecute(long now) {
        return Duration.ofMillis((long)((double)this.fillIntervalMillis / ((double)(2L * this.maxTokens) - this.calcTokenRatio(now, 0) * (double)this.fillIntervalMillis) + 1.0));
    }
}

