/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.rest;

import com.atlassian.event.remote.impl.DefaultRemoteEventProducerRegistrar;
import com.atlassian.event.remote.impl.cache.EventSubscriptionCapabilities;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Singleton
@UnrestrictedAccess
public class RemoteEventProducerResource {
    private static final Logger log = LoggerFactory.getLogger(RemoteEventProducerResource.class);
    private final EventSubscriptionCapabilities eventSubscriptions;
    private final HttpUtil httpUtil;
    private final DefaultRemoteEventProducerRegistrar producerRegistrar;

    @Inject
    public RemoteEventProducerResource(EventSubscriptionCapabilities eventSubscriptions, @ComponentImport HttpUtil httpUtil, DefaultRemoteEventProducerRegistrar producerRegistrar) {
        this.eventSubscriptions = eventSubscriptions;
        this.httpUtil = httpUtil;
        this.producerRegistrar = producerRegistrar;
    }

    @GET
    @Path(value="capabilities")
    @Produces(value={"application/json"})
    public Response getCapabilities() {
        return this.httpUtil.getOkJsonResponse(this.producerRegistrar.publishedCapabilities());
    }

    @POST
    @Path(value="refresh")
    public Response refresh() {
        log.debug("Refreshing event subscriptions");
        this.eventSubscriptions.clear();
        return Response.ok((Object)"OK").build();
    }
}

