/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.util;

import java.util.Properties;

public class PropertiesParser {
    private final Properties properties;
    private final String prefix;

    public PropertiesParser(Properties properties, String prefix) {
        this.properties = properties;
        this.prefix = prefix;
    }

    public boolean parseBoolean(String suffix, boolean defaultValue) {
        String value = this.properties.getProperty(this.prefix + suffix);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public int parseInteger(String suffix, int defaultValue) {
        String value = this.properties.getProperty(this.prefix + suffix);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }
}

