/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal;

import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerCreationException;
import com.atlassian.oauth.consumer.core.ConsumerServiceStore;
import com.atlassian.oauth.consumer.core.HostConsumerAndSecretProvider;
import com.atlassian.oauth.consumer.sal.Constants;
import com.atlassian.oauth.consumer.sal.ConsumerProperties;
import com.atlassian.oauth.consumer.sal.KeyPairFactory;
import com.atlassian.oauth.consumer.sal.SecurePropertiesStore;
import com.atlassian.oauth.shared.sal.PrefixingPluginSettings;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SecureSettingsHostConsumerAndSecretProviderImpl
implements HostConsumerAndSecretProvider {
    private static final SecureRandom random = new SecureRandom();
    private final ApplicationProperties applicationProperties;
    private final KeyPairFactory keyPairFactory;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final I18nResolver i18n;
    private final SecretService secretService;

    public SecureSettingsHostConsumerAndSecretProviderImpl(@Nonnull ApplicationProperties applicationProperties, @Nonnull PluginSettingsFactory pluginSettingsFactory, @Nonnull KeyPairFactory keyPairFactory, @Nonnull I18nResolver i18nResolver, @Nullable SecretService secretService) {
        this.applicationProperties = Objects.requireNonNull(applicationProperties, "applicationProperties");
        this.pluginSettingsFactory = Objects.requireNonNull(pluginSettingsFactory, "pluginSettingsFactory");
        this.keyPairFactory = Objects.requireNonNull(keyPairFactory, "keyPairFactory");
        this.i18n = Objects.requireNonNull(i18nResolver, "i18nResolver");
        this.secretService = secretService;
    }

    public synchronized ConsumerServiceStore.ConsumerAndSecret get() {
        Settings settings = this.settings();
        ConsumerServiceStore.ConsumerAndSecret hostCas = settings.get();
        if (hostCas != null) {
            return hostCas;
        }
        hostCas = this.createHostConsumerAndSecret();
        settings.put(hostCas);
        return hostCas;
    }

    public ConsumerServiceStore.ConsumerAndSecret put(ConsumerServiceStore.ConsumerAndSecret hostCas) {
        Settings settings = this.settings();
        settings.put(hostCas);
        return settings.get();
    }

    private ConsumerServiceStore.ConsumerAndSecret createHostConsumerAndSecret() {
        KeyPair keyPair;
        String key = this.generateConsumerKey();
        try {
            keyPair = this.keyPairFactory.newKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new ConsumerCreationException("Could not create key pair for consumer", (Throwable)e);
        }
        Consumer consumer = Consumer.key((String)key).name(this.applicationProperties.getDisplayName()).publicKey(keyPair.getPublic()).description(this.i18n.getText("host.consumer.default.description", new Serializable[]{this.applicationProperties.getDisplayName(), this.applicationProperties.getBaseUrl(UrlMode.CANONICAL)})).build();
        return new ConsumerServiceStore.ConsumerAndSecret("__HOST_SERVICE__", consumer, keyPair.getPrivate());
    }

    private String generateConsumerKey() {
        StringBuilder stringBuilder = new StringBuilder(this.applicationProperties.getDisplayName());
        stringBuilder.append(":");
        random.ints(10L, 0, 10).forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    private Settings settings() {
        return new Settings(this, this.pluginSettingsFactory.createGlobalSettings(), this.secretService);
    }

    final class Settings {
        private PluginSettings pluginSettings;
        private SecurePropertiesStore securePropertiesStore;

        public Settings(SecureSettingsHostConsumerAndSecretProviderImpl this$0, PluginSettings settings, SecretService secretService) {
            this.pluginSettings = new PrefixingPluginSettings(Objects.requireNonNull(settings, "settings"), Constants.HOST_CONSUMER_PROPS_PREFIX);
            this.securePropertiesStore = secretService != null ? new SecurePropertiesStore(secretService, Constants.HOST_CONSUMER_PROPS_PREFIX) : null;
        }

        public ConsumerServiceStore.ConsumerAndSecret get() {
            Object pluginSettingsProps = this.pluginSettings.get("__HOST_SERVICE__");
            Properties properties = null;
            if (pluginSettingsProps instanceof Properties) {
                properties = (Properties)pluginSettingsProps;
            } else if (this.canUseSecretStore(pluginSettingsProps)) {
                properties = this.securePropertiesStore.get("__HOST_SERVICE__").orElse(null);
            }
            if (properties == null) {
                return null;
            }
            return new ConsumerProperties(properties).asConsumerAndSecret("__HOST_SERVICE__");
        }

        public void put(ConsumerServiceStore.ConsumerAndSecret cas) {
            Object pluginSettingsProps = this.pluginSettings.get("__HOST_SERVICE__");
            if (this.canUseSecretStore(pluginSettingsProps)) {
                this.securePropertiesStore.put("__HOST_SERVICE__", new ConsumerProperties(cas).asProperties());
            } else {
                this.pluginSettings.put("__HOST_SERVICE__", (Object)new ConsumerProperties(cas).asProperties());
            }
        }

        private boolean canUseSecretStore(Object pluginSettingsProps) {
            return SecretService.getState() == SecretServiceState.ENABLED && "{ATL_SECURED}".equals(pluginSettingsProps) && this.securePropertiesStore != null;
        }
    }
}

