/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.consumer.sal.upgrade.v2;

import com.atlassian.oauth.consumer.sal.Constants;
import com.atlassian.oauth.consumer.sal.SecurePropertiesStore;
import com.atlassian.oauth.shared.sal.PrefixingPluginSettings;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultSecureHostConsumerUpgradeTask
implements PluginUpgradeTask {
    private final I18nResolver i18nResolver;
    private final PluginSettings pluginSettings;
    private final SecretService secretService;

    public DefaultSecureHostConsumerUpgradeTask(I18nResolver i18nResolver, PluginSettingsFactory pluginSettingsFactory, SecretService secretService) {
        this.i18nResolver = i18nResolver;
        this.pluginSettings = new PrefixingPluginSettings(pluginSettingsFactory.createGlobalSettings(), Constants.HOST_CONSUMER_PROPS_PREFIX);
        this.secretService = secretService;
    }

    public int getBuildNumber() {
        return 2;
    }

    @Nonnull
    public String getShortDescription() {
        return "Migrate the host consumer and secret credentials to secure storage";
    }

    @Nullable
    public Collection<Message> doUpgrade() throws Exception {
        if (SecretService.getState() == SecretServiceState.DISABLED || this.secretService == null) {
            Message warningMessage = this.i18nResolver.createMessage("host.consumer.upgradetask.v2.error.nosecretservice", new Serializable[0]);
            return Collections.singletonList(warningMessage);
        }
        Object props = this.pluginSettings.get("__HOST_SERVICE__");
        if (props instanceof Properties) {
            new SecurePropertiesStore(this.secretService, Constants.HOST_CONSUMER_PROPS_PREFIX).put("__HOST_SERVICE__", (Properties)props);
        }
        this.pluginSettings.put("__HOST_SERVICE__", (Object)"{ATL_SECURED}");
        return Collections.emptyList();
    }

    @Nonnull
    public String getPluginKey() {
        return "com.atlassian.oauth.consumer.sal";
    }
}

