/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.util.ClassLoaderStack;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginHttpSessionWrapper
implements HttpSession {
    private HttpSession delegate;
    private static final Logger log = LoggerFactory.getLogger(PluginHttpSessionWrapper.class);

    public PluginHttpSessionWrapper(HttpSession session) {
        this.delegate = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        ClassLoader classLoader = ClassLoaderStack.pop();
        try {
            if (log.isDebugEnabled()) {
                log.debug("getAttribute('{}') Popping ClassLoader: {}. New ContextClassLoader: {}", new Object[]{name, classLoader, Thread.currentThread().getContextClassLoader()});
            }
            Object object = this.delegate.getAttribute(name);
            return object;
        }
        finally {
            ClassLoaderStack.push((ClassLoader)classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        ClassLoader classLoader = ClassLoaderStack.pop();
        try {
            this.delegate.setAttribute(name, value);
        }
        finally {
            ClassLoaderStack.push((ClassLoader)classLoader);
        }
    }

    public long getCreationTime() {
        return this.delegate.getCreationTime();
    }

    public String getId() {
        return this.delegate.getId();
    }

    public long getLastAccessedTime() {
        return this.delegate.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.delegate.getServletContext();
    }

    public void setMaxInactiveInterval(int interval) {
        this.delegate.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.delegate.getMaxInactiveInterval();
    }

    public Enumeration<String> getAttributeNames() {
        return this.delegate.getAttributeNames();
    }

    public void removeAttribute(String name) {
        this.delegate.removeAttribute(name);
    }

    public void invalidate() {
        this.delegate.invalidate();
    }

    public boolean isNew() {
        return this.delegate.isNew();
    }
}

