/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.sal.api.auth.AuthenticationController;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;

public class AuthenticationControllerImpl
implements AuthenticationController {
    private final AuthenticationContext authenticationContext;
    private final LicenseService licenseService;

    public AuthenticationControllerImpl(AuthenticationContext authenticationContext, LicenseService licenseService) {
        this.authenticationContext = authenticationContext;
        this.licenseService = licenseService;
    }

    public boolean shouldAttemptAuthentication(HttpServletRequest httpServletRequest) {
        return (httpServletRequest == null || httpServletRequest.getUserPrincipal() == null) && this.authenticationContext.getCurrentUser() == null;
    }

    public boolean canLogin(Principal principal, HttpServletRequest httpServletRequest) {
        return this.licenseService.canLogin(principal);
    }
}

