/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.auth;

import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.auth.SimpleAuthentication;
import com.atlassian.bitbucket.event.auth.AuthenticationFailureEvent;
import com.atlassian.bitbucket.event.auth.AuthenticationSuccessEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.CaptchaService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.google.common.annotations.VisibleForTesting;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationListenerImpl
implements AuthenticationListener {
    @VisibleForTesting
    static final String SSO_LOGIN = "com.atlassian.plugins.authentication.userLoggedInWithSso";
    @VisibleForTesting
    static final String TWO_STEP_VERIFICATION_COMPATIBLE_LOGIN = "com.atlassian.plugins.authentication.2sv.login";
    private static final Logger log = LoggerFactory.getLogger(AuthenticationListenerImpl.class);
    private final AuthenticationService authenticationService;
    private final CaptchaService captchaService;
    private final EventPublisher eventPublisher;
    private final SecurityService securityService;
    private final UserService userService;

    public AuthenticationListenerImpl(AuthenticationService authenticationService, CaptchaService captchaService, EventPublisher eventPublisher, SecurityService securityService, UserService userService) {
        this.authenticationService = authenticationService;
        this.captchaService = captchaService;
        this.eventPublisher = eventPublisher;
        this.securityService = securityService;
        this.userService = userService;
    }

    public void authenticationSuccess(Authenticator.Result result, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        if (result.getPrincipal() == null) {
            return;
        }
        String username = result.getPrincipal().getName();
        ApplicationUser user = this.userService.getUserByName(username, false);
        if (user == null) {
            user = this.userService.getServiceUserByName(username);
        }
        this.authenticationService.set(SimpleAuthentication.builder((ApplicationUser)user).build());
        this.postTwoStepVerificationLogin(httpServletRequest, username);
        this.eventPublisher.publish((Object)new AuthenticationSuccessEvent((Object)this, username, "plugin"));
    }

    public void authenticationFailure(Authenticator.Result result, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String username = result != null && result.getPrincipal() != null ? result.getPrincipal().getName() : null;
        this.eventPublisher.publish((Object)new AuthenticationFailureEvent((Object)this, username, "plugin", null));
    }

    public void authenticationError(Authenticator.Result result, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
    }

    public void authenticationNotAttempted(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
    }

    private static boolean isSsoLoginRequest(HttpServletRequest request) {
        return Objects.equals(request.getAttribute(SSO_LOGIN), true);
    }

    private static boolean isTwoStepVerificationLoginRequest(HttpServletRequest request) {
        return Objects.equals(request.getAttribute(TWO_STEP_VERIFICATION_COMPATIBLE_LOGIN), true);
    }

    private void postTwoStepVerificationLogin(HttpServletRequest request, String username) {
        if (!AuthenticationListenerImpl.isSsoLoginRequest(request) && AuthenticationListenerImpl.isTwoStepVerificationLoginRequest(request)) {
            log.debug("{}: Successful two-step verification compatible login request. Explicitly clearing failed authentication attempts.", (Object)username);
            this.securityService.withPermission(Permission.ADMIN, "Clear failed login attempts on successful authentication").call(() -> {
                this.captchaService.clear(username);
                return null;
            });
        }
    }
}

