/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.auth;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.page.PageCapability;
import com.atlassian.sal.api.user.UserRole;
import java.net.URI;
import java.util.EnumSet;

public class LoginUriProviderImpl
implements LoginUriProvider {
    private final NavBuilder navBuilder;

    public LoginUriProviderImpl(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
    }

    public URI getLoginUri(URI uri) {
        NavBuilder.Login login = this.basicLogin();
        return this.buildLoginUri(login, uri);
    }

    public URI getLoginUri(URI uri, EnumSet<PageCapability> pageCapabilities) {
        NavBuilder.Login login = this.basicLogin();
        login = this.maybeEmbedded(login, pageCapabilities);
        return this.buildLoginUri(login, uri);
    }

    public URI getLoginUriForRole(URI uri, UserRole userRole) {
        NavBuilder.Login login = this.basicLogin();
        login = this.maybeWithRole(login, userRole);
        return this.buildLoginUri(login, uri);
    }

    public URI getLoginUriForRole(URI uri, UserRole userRole, EnumSet<PageCapability> pageCapabilities) {
        NavBuilder.Login login = this.basicLogin();
        login = this.maybeEmbedded(login, pageCapabilities);
        login = this.maybeWithRole(login, userRole);
        return this.buildLoginUri(login, uri);
    }

    private NavBuilder.Login basicLogin() {
        return this.navBuilder.login();
    }

    private URI buildLoginUri(NavBuilder.Login login, URI uri) {
        return UrlUtils.uncheckedCreateURI((String)((NavBuilder.Login)login.next(uri.toASCIIString())).buildAbsolute());
    }

    private NavBuilder.Login maybeEmbedded(NavBuilder.Login login, EnumSet<PageCapability> pageCapabilities) {
        if (pageCapabilities.contains(PageCapability.IFRAME)) {
            return login.embedded();
        }
        return login;
    }

    private NavBuilder.Login maybeWithRole(NavBuilder.Login login, UserRole role) {
        switch (role) {
            case SYSADMIN: {
                return login.sysadmin();
            }
            case ADMIN: {
                return login.admin();
            }
        }
        return login;
    }
}

