/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.auth;

import com.atlassian.bitbucket.dmz.xsrf.XsrfTokenStore;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionBasedXsrfTokenAccessor
implements XsrfTokenAccessor {
    public static final String XSRF_TOKEN_NAME = "xsrfTokenName";
    public static final String XSRF_TOKEN_VALUE = "xsrfTokenValue";
    private static final Logger log = LoggerFactory.getLogger(SessionBasedXsrfTokenAccessor.class);
    private final XsrfTokenStore tokenStore;

    public SessionBasedXsrfTokenAccessor(XsrfTokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public String getXsrfToken(HttpServletRequest request, HttpServletResponse response, boolean create) {
        String sessionToken;
        HttpSession session = request.getSession(false);
        if (!create) {
            if (session == null) {
                return null;
            }
            if (this.tokenStore.hasInvalidToken(request)) {
                return (String)session.getAttribute(XSRF_TOKEN_VALUE);
            }
        }
        if ((sessionToken = this.tokenStore.getToken(request)) != null) {
            return sessionToken;
        }
        if (create) {
            String token;
            session = request.getSession(true);
            if (response.isCommitted()) {
                log.warn("Adding token to session for with a committed response, this may have no effect");
            }
            if ((token = this.tokenStore.generateToken(request)) != null) {
                this.tokenStore.saveToken(token, request);
                session.setAttribute(XSRF_TOKEN_NAME, (Object)this.tokenStore.getXsrfTokenName());
                session.setAttribute(XSRF_TOKEN_VALUE, (Object)token);
                return token;
            }
        }
        return null;
    }
}

