/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.license;

import com.atlassian.bitbucket.Product;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public class BaseLicenseDetailsImpl
implements SingleProductLicenseDetailsView {
    private final BitbucketServerLicense delegate;

    public BaseLicenseDetailsImpl(@Nonnull BitbucketServerLicense delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public boolean isEvaluationLicense() {
        return this.delegate.isEvaluation();
    }

    @Nonnull
    public String getLicenseTypeName() {
        return this.delegate.getLicenseType().name();
    }

    @Nullable
    public String getOrganisationName() {
        return this.delegate.getOrganisation().getName();
    }

    @Nullable
    public String getSupportEntitlementNumber() {
        return this.delegate.getSupportEntitlementNumber();
    }

    @Nullable
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Nullable
    public String getServerId() {
        return this.delegate.getServerId();
    }

    public boolean isPerpetualLicense() {
        return this.getLicenseExpiryDate() == null;
    }

    @Nullable
    public Date getLicenseExpiryDate() {
        return this.delegate.getExpiryDate();
    }

    @Nullable
    public Date getMaintenanceExpiryDate() {
        return this.delegate.getMaintenanceExpiryDate();
    }

    public boolean isDataCenter() {
        return this.delegate.isClusteringEnabled();
    }

    public boolean isEnterpriseLicensingAgreement() {
        throw new UnsupportedOperationException("Cannot detect whether Bitbucket license is ELA");
    }

    @Nonnull
    public String getProductKey() {
        return "bitbucket";
    }

    public boolean isUnlimitedNumberOfUsers() {
        return this.delegate.isUnlimitedNumberOfUsers();
    }

    public int getNumberOfUsers() {
        return this.delegate.getMaximumNumberOfUsers();
    }

    @Nonnull
    public String getProductDisplayName() {
        return this.delegate.isClusteringEnabled() ? Product.DATA_CENTER_NAME : Product.NAME;
    }

    @Nullable
    public String getProperty(@Nonnull String property) {
        return this.delegate.getProperty(Objects.requireNonNull(property, "property"));
    }
}

