/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.license;

import com.atlassian.bitbucket.event.license.LicenseChangedEvent;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.sal.api.i18n.InvalidOperationException;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.RawProductLicense;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.api.validate.MultipleLicensesValidationResult;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.stash.sal.api.license.BaseLicenseDetailsImpl;
import com.atlassian.stash.sal.api.license.LicenseChangedEventImpl;
import com.atlassian.stash.sal.api.license.MultiProductLicenseDetailsImpl;
import com.atlassian.stash.sal.api.util.JohnsonHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LicenseHandlerImpl
implements LicenseHandler {
    private final EventPublisher eventPublisher;
    private final JohnsonHelper johnsonHelper;
    private final LicenseService licenseService;

    public LicenseHandlerImpl(EventPublisher eventPublisher, JohnsonHelper johnsonHelper, LicenseService licenseService) {
        this.eventPublisher = eventPublisher;
        this.johnsonHelper = johnsonHelper;
        this.licenseService = licenseService;
    }

    public void addProductLicense(@Nonnull String productKey, @Nonnull String license) throws InvalidOperationException {
        if (this.isJohnsoned()) {
            throw new InvalidOperationException("Server is not running", "Server is not running");
        }
        try {
            this.licenseService.set(license);
        }
        catch (InvalidLicenseException e) {
            throw new InvalidOperationException(e.getMessage(), e.getLocalizedMessage());
        }
    }

    public void addProductLicenses(@Nonnull Set<RawProductLicense> rawProductLicenses) throws InvalidOperationException {
        if (rawProductLicenses.isEmpty()) {
            return;
        }
        if (rawProductLicenses.size() > 1) {
            throw new UnsupportedOperationException("Adding multiple licenses is unsupported in Bitbucket Data Center");
        }
        RawProductLicense rawProductLicense = (RawProductLicense)rawProductLicenses.stream().findAny().get();
        if (rawProductLicense.isDeleteLicense()) {
            throw new UnsupportedOperationException("removeProductLicense is unsupported in Bitbucket Data Center");
        }
        if (rawProductLicense.getProductKey().isPresent() && rawProductLicense.getLicense().isPresent()) {
            this.addProductLicense((String)rawProductLicense.getProductKey().get(), (String)rawProductLicense.getLicense().get());
        }
    }

    @Nonnull
    public MultiProductLicenseDetails decodeLicenseDetails(@Nonnull String license) {
        throw new UnsupportedOperationException("decodeLicenseDetails is unsupported in Bitbucket Data Center");
    }

    @Nonnull
    public Collection<MultiProductLicenseDetails> getAllProductLicenses() {
        if (this.isJohnsoned()) {
            return Collections.emptySet();
        }
        BitbucketServerLicense license = this.licenseService.get();
        return license == null ? Collections.emptySet() : Collections.singleton(new MultiProductLicenseDetailsImpl(license));
    }

    @Nonnull
    public SortedSet<String> getAllSupportEntitlementNumbers() {
        if (this.isJohnsoned()) {
            return Collections.emptySortedSet();
        }
        BitbucketServerLicense license = this.licenseService.get();
        String sen = license == null ? null : license.getSupportEntitlementNumber();
        return sen == null ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet<String>(Collections.singleton(sen)));
    }

    public Set<String> getProductKeys() {
        if (this.isJohnsoned()) {
            return Collections.emptySet();
        }
        return Collections.singleton("stash");
    }

    public SingleProductLicenseDetailsView getProductLicenseDetails(@Nonnull String productKey) {
        if (this.isJohnsoned()) {
            return null;
        }
        BitbucketServerLicense license = this.licenseService.get();
        return license == null ? null : new BaseLicenseDetailsImpl(license);
    }

    public String getRawProductLicense(String productKey) {
        if (this.isJohnsoned()) {
            return null;
        }
        BitbucketServerLicense license = this.licenseService.get();
        if (license == null || !license.getProduct().getNamespace().equalsIgnoreCase(productKey)) {
            return null;
        }
        return this.licenseService.getAsString();
    }

    public String getServerId() {
        if (this.isJohnsoned()) {
            return null;
        }
        BitbucketServerLicense license = this.licenseService.get();
        return license == null ? null : license.getServerId();
    }

    public String getSupportEntitlementNumber() {
        if (this.isJohnsoned()) {
            return null;
        }
        BitbucketServerLicense license = this.licenseService.get();
        return license == null ? null : license.getSupportEntitlementNumber();
    }

    public boolean hostAllowsCustomProducts() {
        return false;
    }

    public boolean hostAllowsMultipleLicenses() {
        return false;
    }

    @EventListener
    public void onLicenseChanged(LicenseChangedEvent licenseChangedEvent) {
        BaseLicenseDetailsImpl newLicense = licenseChangedEvent.getNewLicense() == null ? null : new BaseLicenseDetailsImpl(licenseChangedEvent.getNewLicense());
        BaseLicenseDetailsImpl previousLicense = licenseChangedEvent.getPreviousLicense() == null ? null : new BaseLicenseDetailsImpl(licenseChangedEvent.getPreviousLicense());
        this.eventPublisher.publish((Object)new LicenseChangedEventImpl((BaseLicenseDetails)newLicense, (BaseLicenseDetails)previousLicense));
    }

    public void removeProductLicense(@Nonnull String productKey) throws InvalidOperationException {
        throw new UnsupportedOperationException("removeProductLicense is unsupported in Bitbucket Data Center");
    }

    public void setLicense(String license) {
        if (this.isJohnsoned()) {
            return;
        }
        this.licenseService.set(license);
    }

    @Nonnull
    public MultipleLicensesValidationResult validateMultipleProductLicenses(@Nonnull Set<RawProductLicense> rawProductLicenses, @Nullable Locale locale) {
        throw new UnsupportedOperationException("validateMultipleProductLicenses is unsupported in Bitbucket Data Center");
    }

    @Nonnull
    public ValidationResult validateProductLicense(@Nonnull String productKey, @Nonnull String license, Locale locale) {
        throw new UnsupportedOperationException("validateProductLicense is unsupported in Bitbucket Data Center");
    }

    private boolean isJohnsoned() {
        return this.johnsonHelper.isJohnsoned();
    }
}

