/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.sal.api.lifecycle;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShuttingDownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.lifecycle.LifecycleManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class PatchedLifecycleManager
implements LifecycleManager,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(PatchedLifecycleManager.class);
    private final PluginEventManager pluginEventManager;
    private final PluginAccessor pluginAccessor;
    private final BundleContext bundleContext;
    private final Set<ServiceReference<LifecycleAware>> pendingOnStart;
    private final Set<ServiceReference<LifecycleAware>> pendingOnStop;
    private final Queue<String> pluginsPendingOnStart;
    private final ServiceListener serviceListener;
    private volatile boolean started;

    public PatchedLifecycleManager(PluginEventManager pluginEventManager, PluginAccessor pluginAccessor, BundleContext bundleContext) {
        this.pluginEventManager = pluginEventManager;
        this.pluginAccessor = pluginAccessor;
        this.bundleContext = bundleContext;
        this.pendingOnStart = Collections.synchronizedSet(new HashSet());
        this.pendingOnStop = Collections.synchronizedSet(new HashSet());
        this.pluginsPendingOnStart = new ConcurrentLinkedQueue<String>();
        this.serviceListener = new LifecycleAwareServiceListener();
        this.started = false;
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
        String filter = "(objectClass=" + LifecycleAware.class.getName() + ")";
        this.bundleContext.addServiceListener(this.serviceListener, filter);
        Collection services = this.bundleContext.getServiceReferences(LifecycleAware.class, null);
        this.pendingOnStart.addAll(services);
        for (ServiceReference service : services) {
            if (null != service.getBundle()) continue;
            this.pendingOnStart.remove(service);
        }
    }

    private void clearPendingOnStop() {
        if (this.pendingOnStop.isEmpty()) {
            return;
        }
        log.warn("Failed to notify with LifecycleAware.onStop(): {}", (Object)PatchedLifecycleManager.listPluginKeys(Arrays.asList((ServiceReference[])this.pendingOnStop.toArray())));
        this.pendingOnStop.clear();
    }

    public void destroy() {
        this.bundleContext.removeServiceListener(this.serviceListener);
        this.pendingOnStart.clear();
        this.pluginsPendingOnStart.clear();
        this.clearPendingOnStop();
        this.pluginEventManager.unregister((Object)this);
    }

    @PluginEventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.startIfApplicationSetup();
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        String pluginKey = event.getPlugin().getKey();
        if (this.started) {
            this.notifyStartableLifecycleAwaresForPlugin(pluginKey);
        } else {
            this.pluginsPendingOnStart.add(pluginKey);
        }
    }

    @PluginEventListener
    public void onPluginFrameworkShuttingDown(PluginFrameworkShuttingDownEvent event) {
        Collection<ServiceReference<LifecycleAware>> completed = this.notifyLifecycleAwares(this.pendingOnStop, this::notifyOnStopIfEnabled);
        this.pendingOnStop.removeAll(completed);
    }

    private Predicate<ServiceReference<LifecycleAware>> notifyIfMyEvent(PluginDisablingEvent event) {
        return lifecycleAwareServiceReference -> {
            Bundle bundle = lifecycleAwareServiceReference.getBundle();
            if (bundle == null) {
                log.warn("Discarding onStop() for stale LifecycleAware");
                return true;
            }
            return PatchedLifecycleManager.getPluginKey(bundle).equals(event.getPlugin().getKey()) && this.notifyOnStopIfEnabled((ServiceReference<LifecycleAware>)lifecycleAwareServiceReference);
        };
    }

    @PluginEventListener
    public void onPluginDisabling(PluginDisablingEvent event) {
        Collection<ServiceReference<LifecycleAware>> completed = this.notifyLifecycleAwares(this.pendingOnStop, this.notifyIfMyEvent(event));
        this.pendingOnStop.removeAll(completed);
    }

    public void start() {
        this.startIfApplicationSetup();
    }

    private void startIfApplicationSetup() {
        boolean doSetup;
        boolean bl = doSetup = !this.started && this.isApplicationSetUp();
        if (doSetup) {
            this.started = true;
            this.notifyStartableLifecycleAwares();
            this.notifyOnStart();
        }
    }

    protected void notifyOnStart() {
    }

    private void notifyStartableLifecycleAwares() {
        String pluginKey;
        while ((pluginKey = this.pluginsPendingOnStart.poll()) != null) {
            this.notifyStartableLifecycleAwaresForPlugin(pluginKey);
        }
        int numPending = this.pendingOnStart.size();
        if (numPending > 0) {
            log.info("{} LifecycleAware services found that are pending initialization", (Object)numPending);
            this.notifyStartableLifecycleAwares(this.pendingOnStart);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStartableLifecycleAwaresForPlugin(String pluginKey) {
        HashSet<ServiceReference<LifecycleAware>> pendingForPlugin;
        Set<ServiceReference<LifecycleAware>> set = this.pendingOnStart;
        synchronized (set) {
            pendingForPlugin = new HashSet<ServiceReference<LifecycleAware>>(this.pendingOnStart);
        }
        pendingForPlugin.removeIf(ref -> !pluginKey.equals(PatchedLifecycleManager.getPluginKeyFromBundle(ref.getBundle())));
        int startedCount = this.notifyStartableLifecycleAwares(pendingForPlugin);
        if (startedCount > 0 && log.isTraceEnabled()) {
            log.trace("Started {} LifeCycleAware services for plugin {}; {} still pending for other plugins", new Object[]{startedCount, pluginKey, this.pendingOnStart.size()});
        }
    }

    private int notifyStartableLifecycleAwares(Set<ServiceReference<LifecycleAware>> serviceReferences) {
        Collection<ServiceReference<LifecycleAware>> completed = this.notifyLifecycleAwares(serviceReferences, this::notifyOnStartIfStartedAndEnabled);
        this.pendingOnStart.removeAll(completed);
        this.pendingOnStop.addAll(completed);
        return completed.size();
    }

    private Collection<ServiceReference<LifecycleAware>> notifyLifecycleAwares(Set<ServiceReference<LifecycleAware>> lifeCycleAwares, Predicate<ServiceReference<LifecycleAware>> event) {
        Object[] pending = lifeCycleAwares.toArray();
        ArrayList<ServiceReference<LifecycleAware>> completed = new ArrayList<ServiceReference<LifecycleAware>>(pending.length);
        for (Object serviceRaw : pending) {
            ServiceReference service = (ServiceReference)serviceRaw;
            if (!event.test((ServiceReference<LifecycleAware>)service)) continue;
            completed.add((ServiceReference<LifecycleAware>)service);
        }
        return completed;
    }

    private boolean notifyOnStartIfStartedAndEnabled(ServiceReference<LifecycleAware> service) {
        if (this.started) {
            return this.notifyLifecycleAware(service, new Consumer<LifecycleAware>(this){

                @Override
                public void accept(LifecycleAware lifecycleAware) {
                    lifecycleAware.onStart();
                }

                public String toString() {
                    return "onStart()";
                }
            });
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean notifyLifecycleAware(ServiceReference<LifecycleAware> service, Consumer<LifecycleAware> event) {
        Bundle bundle = service.getBundle();
        LifecycleAware lifecycleAware = (LifecycleAware)this.bundleContext.getService(service);
        try {
            if (null != bundle && null != lifecycleAware) {
                String pluginKey = PatchedLifecycleManager.getPluginKey(bundle);
                if (this.pluginAccessor.isPluginEnabled(pluginKey)) {
                    try {
                        log.debug("Calling LifecycleAware.{} '{}' from plugin '{}'", new Object[]{event, lifecycleAware, pluginKey});
                        event.accept(lifecycleAware);
                    }
                    catch (Throwable ex) {
                        log.error("LifecycleAware.{} failed for component with class '{}' from plugin '{}'", new Object[]{event, lifecycleAware.getClass().getName(), pluginKey, ex});
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            log.warn("Discarding {} for stale LifecycleAware", event);
            boolean bl = true;
            return bl;
        }
        finally {
            if (null != lifecycleAware) {
                this.bundleContext.ungetService(service);
            }
        }
    }

    private boolean notifyOnStopIfEnabled(ServiceReference<LifecycleAware> service) {
        return this.notifyLifecycleAware(service, new Consumer<LifecycleAware>(this){

            @Override
            public void accept(LifecycleAware lifecycleAware) {
                try {
                    lifecycleAware.onStop();
                }
                catch (AbstractMethodError e) {
                    Class clazz = lifecycleAware.getClass();
                    try {
                        Method onStop = clazz.getMethod("onStop", new Class[0]);
                        if (onStop.getDeclaringClass() != LifecycleAware.class) {
                            throw e;
                        }
                        log.debug("'{}' does not implement onStop()", (Object)clazz.getName());
                    }
                    catch (NoSuchMethodException nsme) {
                        log.warn("'{}' does not declare onStop()", (Object)clazz.getName());
                    }
                }
            }

            public String toString() {
                return "onStop()";
            }
        });
    }

    static String getPluginKey(Bundle bundle) {
        String pluginKey = (String)bundle.getHeaders().get("Atlassian-Plugin-Key");
        if (pluginKey != null) {
            return pluginKey;
        }
        return bundle.getSymbolicName() + " - " + (String)bundle.getHeaders().get("Bundle-Version");
    }

    @Nonnull
    static String getPluginKeyFromBundle(@Nullable Bundle bundle) {
        return bundle == null ? "<stale service reference>" : PatchedLifecycleManager.getPluginKey(bundle);
    }

    @Nonnull
    static <T> String listPluginKeys(@Nonnull Collection<ServiceReference<T>> services) {
        return services.stream().map(service -> PatchedLifecycleManager.getPluginKeyFromBundle(service.getBundle())).collect(Collectors.joining(", ", "[", "]"));
    }

    private class LifecycleAwareServiceListener
    implements ServiceListener {
        private LifecycleAwareServiceListener() {
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            ServiceReference service = serviceEvent.getServiceReference();
            switch (serviceEvent.getType()) {
                case 1: {
                    if (PatchedLifecycleManager.this.notifyOnStartIfStartedAndEnabled((ServiceReference<LifecycleAware>)service)) break;
                    PatchedLifecycleManager.this.pendingOnStart.add((ServiceReference<LifecycleAware>)service);
                    break;
                }
                case 4: {
                    PatchedLifecycleManager.this.pendingOnStart.remove(service);
                    if (!PatchedLifecycleManager.this.pendingOnStop.remove(service)) break;
                    log.warn("Notifying with LifecycleAware.onStop() on service unregister");
                    if (PatchedLifecycleManager.this.notifyOnStopIfEnabled((ServiceReference<LifecycleAware>)service)) break;
                    Bundle bundle = service.getBundle();
                    log.warn("Failed to notify {} with LifecycleAware.onStop()", (Object)PatchedLifecycleManager.getPluginKeyFromBundle(bundle));
                    break;
                }
            }
        }
    }
}

