/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup;

import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueService;
import com.atlassian.bitbucket.dmz.mergequeue.MergeQueueSettingsService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.PullRequestUpdateRequest;
import com.atlassian.bitbucket.pull.automerge.AutoMergeService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.updateref.GitUpdateRefDeleteBuilder;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupEvent;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupRequest;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupResult;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupService;
import com.atlassian.stash.internal.pull.cleanup.PullRequestSourceBranchDeletedEvent;
import com.atlassian.stash.internal.pull.cleanup.dao.PullRequestPendingCleanupRequestDao;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultPullRequestCleanupService
implements PullRequestCleanupService {
    private static final int MAX_PULL_REQUESTS_TO_RETARGET = 100;
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestCleanupService.class);
    private final AutoMergeService autoMergeService;
    private final GitCommandBuilderFactory builderFactory;
    private final PullRequestPendingCleanupRequestDao dao;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final MergeQueueService mergeQueueService;
    private final MergeQueueSettingsService mergeQueueSettingsService;
    private final PermissionService permissionService;
    private final PullRequestService pullRequestService;
    private final RefRestrictionService refRestrictionService;
    private final RefService refService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public DefaultPullRequestCleanupService(AutoMergeService autoMergeService, GitCommandBuilderFactory builderFactory, PullRequestPendingCleanupRequestDao dao, EventPublisher eventPublisher, FeatureManager featureManager, I18nService i18nService, MergeQueueService mergeQueueService, MergeQueueSettingsService mergeQueueSettingsService, PermissionService permissionService, PullRequestService pullRequestService, RefRestrictionService refRestrictionService, RefService refService, TransactionTemplate transactionTemplate) {
        this.autoMergeService = autoMergeService;
        this.builderFactory = builderFactory;
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.mergeQueueService = mergeQueueService;
        this.mergeQueueSettingsService = mergeQueueSettingsService;
        this.permissionService = permissionService;
        this.pullRequestService = pullRequestService;
        this.refRestrictionService = refRestrictionService;
        this.refService = refService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    @Nonnull
    public PullRequestCleanupResult cleanup(@Nonnull PullRequestCleanupRequest request) {
        Objects.requireNonNull(request, "pullRequestCleanupEvent");
        PullRequestCleanupResult cleanupResult = this.tryCleanup(request);
        PullRequest pullRequest = request.getPullRequest();
        if (!request.isDryRun() && !cleanupResult.isVetoed()) {
            if (pullRequest.getState() != PullRequestState.MERGED) {
                return (PullRequestCleanupResult)this.transactionTemplate.execute(() -> {
                    if (this.isAutoMerged(pullRequest) || this.isQueued(pullRequest)) {
                        this.dao.create(request);
                        return cleanupResult;
                    }
                    throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.on.unmerged.pull.request", new Object[0]));
                });
            }
            PullRequestRef toRef = pullRequest.getToRef();
            if (request.isRetarget()) {
                this.retargetDependents(cleanupResult, toRef);
            }
            if (request.isDeleteSourceRef() && cleanupResult.getSourceBranch() != null) {
                this.deleteSourceBranch(pullRequest, cleanupResult.getSourceBranch());
            }
            if (request.isRetarget() || request.isDeleteSourceRef() && cleanupResult.getSourceBranch() != null) {
                this.eventPublisher.publish((Object)new PullRequestCleanupEvent(this, request, cleanupResult));
            }
        }
        if (!request.isDryRun() && this.dao.deleteByPullRequest(pullRequest)) {
            log.trace("{}: Deleted cleanup request for the pull request; cleanup result vetoes: {}", DefaultPullRequestCleanupService.describe(pullRequest), cleanupResult.getVetoes().stream().map(KeyedMessage::getLocalisedMessage).collect(Collectors.toList()));
        }
        return cleanupResult;
    }

    private static Object describe(final PullRequest pullRequest) {
        return new Object(){

            public String toString() {
                return String.format("[%d:%d@%d]", pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), pullRequest.getVersion());
            }
        };
    }

    private void deleteSourceBranch(PullRequest pullRequest, Branch sourceBranch) {
        PullRequestRef fromRef = pullRequest.getFromRef();
        Repository sourceRepository = fromRef.getRepository();
        ((GitUpdateRefDeleteBuilder)this.builderFactory.builder(sourceRepository).updateRef().delete(fromRef.getId()).oldValue(fromRef.getLatestCommit())).build().call();
        this.eventPublisher.publish((Object)new PullRequestSourceBranchDeletedEvent(this, sourceRepository, sourceBranch));
    }

    private boolean isAutoMerged(PullRequest pullRequest) {
        return this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_AUTO_MERGE) && pullRequest.isOpen() && this.autoMergeService.isSettingEnabledForPullRequest(pullRequest) && this.autoMergeService.getAutoMergeRequest(pullRequest).isPresent();
    }

    private boolean isQueued(PullRequest pullRequest) {
        return this.mergeQueueSettingsService.isEnabled(pullRequest) && pullRequest.isOpen() && this.mergeQueueService.isQueued(pullRequest);
    }

    private Iterable<KeyedMessage> maybeVetoDeleteSourceBranch(PullRequestCleanupRequest cleanupRequest, Branch sourceBranch, Page<PullRequest> dependentPullRequests) {
        RefAccessRequest accessRequest;
        PullRequest pullRequest = cleanupRequest.getPullRequest();
        PullRequestRef fromRef = pullRequest.getFromRef();
        Repository sourceRepository = fromRef.getRepository();
        ImmutableSet.Builder vetoes = ImmutableSet.builder();
        if (!"git".equals(sourceRepository.getScmId())) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.not.git", new Object[]{sourceRepository.getScmId()}));
        }
        if (sourceBranch.getIsDefault()) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.default.branch", new Object[]{sourceBranch.getDisplayId()}));
        }
        if (!this.permissionService.hasRepositoryPermission(sourceRepository, Permission.REPO_WRITE)) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.no.write", new Object[0]));
        }
        if (!this.refRestrictionService.hasPermission(accessRequest = new RefAccessRequest.Builder(sourceRepository, RefAccessType.DELETE).ref((MinimalRef)sourceBranch).build())) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.branch.restrictions", new Object[0]));
        }
        if (!fromRef.getLatestCommit().equals(sourceBranch.getLatestCommit())) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.unmerged.changes", new Object[0]));
        }
        if (!cleanupRequest.isRetarget() && dependentPullRequests.getSize() > 0) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.invalid.request", new Object[0]));
        }
        Page openPullRequests = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(PullRequestDirection.OUTGOING, Integer.valueOf(fromRef.getRepository().getId()), fromRef.getId()).state(PullRequestState.OPEN).withProperties(false).build(), PageUtils.newRequest((int)0, (int)2));
        if (!openPullRequests.stream().allMatch(arg_0 -> ((PullRequest)pullRequest).equals(arg_0))) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.outgoing.pull.request", new Object[0]));
        }
        return vetoes.build();
    }

    private Iterable<KeyedMessage> maybeVetoRetargetDependentPullRequests(PullRequestCleanupRequest cleanupRequest, Page<PullRequest> dependentPullRequests) {
        if (!cleanupRequest.isRetarget() || dependentPullRequests.getSize() == 0) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder vetoes = ImmutableSet.builder();
        if (!dependentPullRequests.getIsLastPage()) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.retarget.too.many", new Object[0]));
        }
        if (cleanupRequest.getPullRequest().isCrossRepository() && dependentPullRequests.getSize() > 0) {
            vetoes.add((Object)this.i18nService.createKeyedMessage("bitbucket.branch.deletion.incoming.pull.request", new Object[0]));
        }
        return vetoes.build();
    }

    private void retargetDependents(PullRequestCleanupResult cleanupResult, PullRequestRef toRef) {
        this.transactionTemplate.execute(() -> {
            cleanupResult.getDependentPullRequests().forEach(pr -> this.pullRequestService.update(new PullRequestUpdateRequest.Builder(pr, pr.getVersion()).title(pr.getTitle()).description(pr.getDescription()).draft(Boolean.valueOf(pr.isDraft())).reviewers((Iterable)pr.getReviewers().stream().map(reviewer -> reviewer.getUser().getName()).collect(Collectors.toSet())).toBranchId(toRef.getId()).build()));
            return null;
        });
    }

    private PullRequestCleanupResult tryCleanup(PullRequestCleanupRequest request) {
        PullRequest pullRequest = request.getPullRequest();
        PullRequestRef fromRef = pullRequest.getFromRef();
        Repository sourceRepository = fromRef.getRepository();
        PullRequestCleanupResult.Builder resultBuilder = new PullRequestCleanupResult.Builder(pullRequest);
        if (this.permissionService.hasRepositoryPermission(sourceRepository, Permission.REPO_READ)) {
            Page dependentPullRequests = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(PullRequestDirection.INCOMING, Integer.valueOf(sourceRepository.getId()), fromRef.getId()).state(PullRequestState.OPEN).build(), PageUtils.newRequest((int)0, (int)100));
            resultBuilder.dependentPullRequests(dependentPullRequests.getValues()).veto(this.maybeVetoRetargetDependentPullRequests(request, (Page<PullRequest>)dependentPullRequests));
            if (request.isDeleteSourceRef()) {
                Ref sourceRef = this.refService.resolveRef(new ResolveRefRequest.Builder(sourceRepository).refId(fromRef.getId()).type(fromRef.getType()).build());
                if (sourceRef == null) {
                    log.debug("{}: {} could not be resolved; it may have already been deleted", DefaultPullRequestCleanupService.describe(pullRequest), (Object)fromRef.getId());
                } else if (sourceRef.getType() == StandardRefType.BRANCH) {
                    resultBuilder.sourceBranch((Branch)sourceRef).veto(this.maybeVetoDeleteSourceBranch(request, (Branch)sourceRef, (Page<PullRequest>)dependentPullRequests));
                } else {
                    resultBuilder.veto(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.not.branch", new Object[0]));
                }
            }
        } else if (request.isDeleteSourceRef()) {
            resultBuilder.veto(this.i18nService.createKeyedMessage("bitbucket.branch.deletion.no.write", new Object[0]));
        }
        return resultBuilder.build();
    }
}

