/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup;

import com.atlassian.bitbucket.dmz.event.pull.DmzPullRequestMergedEvent;
import com.atlassian.bitbucket.dmz.pull.automerge.AutoMergeBulkCancelledEvent;
import com.atlassian.bitbucket.event.pull.PullRequestAutoMergeCancelledEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.util.RetryBackoffUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupRequest;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupResult;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupService;
import com.atlassian.stash.internal.pull.cleanup.dao.PullRequestPendingCleanupRequestDao;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PullRequestCleanupEventListener {
    private static final Logger log = LoggerFactory.getLogger(PullRequestCleanupEventListener.class);
    private final PullRequestPendingCleanupRequestDao dao;
    private final DarkFeatureManager darkFeatureManager;
    private final ScheduledExecutorService executor;
    private final FeatureManager featureManager;
    private final int maxCleanupRetryCount;
    private final Duration maxCleanupRetryDelay;
    private final Duration minCleanupRetryDelay;
    private final PullRequestCleanupService pullRequestCleanupService;
    private final TransactionTemplate transactionTemplate;

    public PullRequestCleanupEventListener(PullRequestPendingCleanupRequestDao dao, DarkFeatureManager darkFeatureManager, ScheduledExecutorService executor, FeatureManager featureManager, @Value(value="${plugin.pullrequest.auto.merge.cleanup.retry.maxCount:5}") int maxCleanupRetryCount, @Value(value="${plugin.pullrequest.auto.merge.cleanup.retry.maxDelay:60}") int maxCleanupRetryDelaySeconds, @Value(value="${plugin.pullrequest.auto.merge.cleanup.retry.minDelay:5}") int minCleanupRetryDelaySeconds, PullRequestCleanupService pullRequestCleanupService, TransactionTemplate transactionTemplate) {
        this.dao = dao;
        this.darkFeatureManager = darkFeatureManager;
        this.executor = executor;
        this.featureManager = featureManager;
        this.maxCleanupRetryCount = maxCleanupRetryCount;
        this.maxCleanupRetryDelay = Duration.ofSeconds(maxCleanupRetryDelaySeconds);
        this.minCleanupRetryDelay = Duration.ofSeconds(minCleanupRetryDelaySeconds);
        this.pullRequestCleanupService = pullRequestCleanupService;
        this.transactionTemplate = transactionTemplate;
    }

    @EventListener
    public void onAutoMergeCancelled(PullRequestAutoMergeCancelledEvent event) {
        this.deleteCleanupRequest((PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) {
        this.deleteCleanupRequest((PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestDeleted(PullRequestDeletedEvent event) {
        this.deleteCleanupRequest((PullRequestEvent)event);
    }

    @EventListener
    public void onPullRequestMerged(DmzPullRequestMergedEvent event) {
        if (this.isAutoMergeFeatureEnabled() || this.isMergeQueueFeatureEnabled()) {
            if (event.isAutoMerge() || event.isMergedRemotely() || event.isQueuedMerge()) {
                this.dao.findByPullRequest(event.getPullRequest()).ifPresent(this::scheduleCleanup);
            } else {
                this.deleteCleanupRequest(event.getPullRequest());
            }
        }
    }

    @EventListener
    public void onPullRequestUpdated(PullRequestUpdatedEvent event) {
        if (event.getPullRequest().isDraft()) {
            this.deleteCleanupRequest((PullRequestEvent)event);
        }
    }

    @EventListener
    public void onRepositoryAutoMergeBulkCancelled(AutoMergeBulkCancelledEvent event) {
        if (this.isAutoMergeFeatureEnabled()) {
            this.executor.submit(() -> {
                int deletedCount = this.dao.deleteByPullRequests(event.getRepository().getId(), event.getPullRequestIds());
                log.trace("{}: Deleted {} clean up requests when deleting for pull request IDs {}", new Object[]{event.getRepository(), deletedCount, event.getPullRequestIds()});
            });
        }
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        if (this.isAutoMergeFeatureEnabled() || this.isMergeQueueFeatureEnabled()) {
            this.executor.submit(() -> {
                Repository repository = event.getRepository();
                int deletedCount = this.dao.deleteByRepository(repository.getId());
                log.trace("{}: Deleted {} clean up requests for this repository", (Object)repository, (Object)deletedCount);
            });
        }
    }

    private static Object describe(final PullRequest pullRequest) {
        return new Object(){

            public String toString() {
                return String.format("[%d:%d@%d]", pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), pullRequest.getVersion());
            }
        };
    }

    private void deleteCleanupRequest(PullRequestEvent event) {
        if (this.isAutoMergeFeatureEnabled() || this.isMergeQueueFeatureEnabled()) {
            PullRequest pullRequest = event.getPullRequest();
            this.deleteCleanupRequest(pullRequest);
        }
    }

    private void deleteCleanupRequest(PullRequest pullRequest) {
        if (this.dao.deleteByPullRequest(pullRequest)) {
            log.trace("{}: Deleted pending cleanup request for pull request", PullRequestCleanupEventListener.describe(pullRequest));
        }
    }

    private boolean isAutoMergeFeatureEnabled() {
        return this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_AUTO_MERGE);
    }

    private boolean isMergeQueueFeatureEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers("merge.queue").orElse(false);
    }

    private void maybeCleanup(PullRequestCleanupRequest cleanupRequest) {
        PullRequest pullRequest = cleanupRequest.getPullRequest();
        if (!this.dao.findByPullRequest(pullRequest).isPresent()) {
            log.debug("{}: Cleanup request for the pull request does not exist anymore, not attempting the cleanup", PullRequestCleanupEventListener.describe(pullRequest));
            return;
        }
        log.trace("{}: Going to perform cleanup for the pull request", PullRequestCleanupEventListener.describe(pullRequest));
        PullRequestCleanupResult result = this.pullRequestCleanupService.cleanup(cleanupRequest);
        if (result.isVetoed()) {
            log.debug("{}: Pull request cleanup was vetoed with following messages and will not be re-attempted: {}", PullRequestCleanupEventListener.describe(pullRequest), result.getVetoes().stream().map(KeyedMessage::getLocalisedMessage).collect(Collectors.toList()));
        } else {
            log.trace("{}: Pull request cleanup was successful", PullRequestCleanupEventListener.describe(pullRequest));
        }
    }

    private void scheduleCleanup(final PullRequestCleanupRequest cleanupRequest) {
        final PullRequest pullRequest = cleanupRequest.getPullRequest();
        log.trace("{}: Submitting request to cleanup the pull request", PullRequestCleanupEventListener.describe(pullRequest));
        this.executor.submit(new Runnable(){
            int retryCount = 0;

            @Override
            public void run() {
                try {
                    PullRequestCleanupEventListener.this.transactionTemplate.execute(() -> {
                        PullRequestCleanupEventListener.this.maybeCleanup(cleanupRequest);
                        return null;
                    });
                }
                catch (RuntimeException e) {
                    ++this.retryCount;
                    if (this.retryCount <= PullRequestCleanupEventListener.this.maxCleanupRetryCount) {
                        Duration delay = RetryBackoffUtils.calculateDelay((int)this.retryCount, (Duration)PullRequestCleanupEventListener.this.minCleanupRetryDelay, (Duration)PullRequestCleanupEventListener.this.maxCleanupRetryDelay);
                        log.debug("{}: Pull request cleanup failed due to a runtime error, retry attempt {}/{} will be performed after {} ", new Object[]{PullRequestCleanupEventListener.describe(pullRequest), this.retryCount, PullRequestCleanupEventListener.this.maxCleanupRetryCount, delay, e});
                        PullRequestCleanupEventListener.this.executor.schedule(this, delay.getSeconds(), TimeUnit.SECONDS);
                    }
                    log.debug("{}: Pull request cleanup failed due to a runtime error. {} retry attempts exhausted ", new Object[]{PullRequestCleanupEventListener.describe(pullRequest), this.retryCount - 1, e});
                    PullRequestCleanupEventListener.this.deleteCleanupRequest(pullRequest);
                }
            }
        });
    }
}

