/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup;

import com.atlassian.bitbucket.pull.PullRequest;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class PullRequestCleanupRequest {
    private final boolean deleteSourceRef;
    private final boolean dryRun;
    private final PullRequest pullRequest;
    private final boolean retarget;

    private PullRequestCleanupRequest(Builder builder) {
        this.deleteSourceRef = builder.deleteSourceRef;
        this.dryRun = builder.dryRun;
        this.pullRequest = builder.pullRequest;
        this.retarget = builder.retarget;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    public boolean isDeleteSourceRef() {
        return this.deleteSourceRef;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isRetarget() {
        return this.retarget;
    }

    public static class Builder {
        private final PullRequest pullRequest;
        private boolean deleteSourceRef;
        private boolean dryRun;
        private boolean retarget;

        public Builder(@Nonnull PullRequest pullRequest) {
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public PullRequestCleanupRequest build() {
            return new PullRequestCleanupRequest(this);
        }

        @Nonnull
        public Builder deleteSourceRef(boolean value) {
            this.deleteSourceRef = value;
            return this;
        }

        @Nonnull
        public Builder dryRun(boolean value) {
            this.dryRun = value;
            return this;
        }

        @Nonnull
        public Builder retarget(boolean value) {
            this.retarget = value;
            return this;
        }
    }
}

