/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup;

import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;

public class PullRequestCleanupResult {
    private final Collection<PullRequest> dependentPullRequests;
    private final PullRequest pullRequest;
    private final Branch sourceBranch;
    private final Collection<KeyedMessage> vetoes;

    private PullRequestCleanupResult(Builder builder) {
        this.dependentPullRequests = builder.dependentPullRequests.build();
        this.pullRequest = builder.pullRequest;
        this.sourceBranch = builder.sourceBranch;
        this.vetoes = builder.vetoes.build();
    }

    @Nonnull
    public Collection<PullRequest> getDependentPullRequests() {
        return this.dependentPullRequests;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nullable
    public Branch getSourceBranch() {
        return this.sourceBranch;
    }

    @Nonnull
    public Collection<KeyedMessage> getVetoes() {
        return this.vetoes;
    }

    public boolean isVetoed() {
        return !this.vetoes.isEmpty();
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<PullRequest> dependentPullRequests;
        private final PullRequest pullRequest;
        private final ImmutableList.Builder<KeyedMessage> vetoes = ImmutableList.builder();
        private Branch sourceBranch;

        public Builder(@Nonnull PullRequest pullRequest) {
            this.dependentPullRequests = ImmutableList.builder();
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        }

        @Nonnull
        public PullRequestCleanupResult build() {
            return new PullRequestCleanupResult(this);
        }

        @Nonnull
        public Builder dependentPullRequest(@Nullable PullRequest pullRequest) {
            Builder.addIf(Objects::nonNull, this.dependentPullRequests, (Object)pullRequest);
            return this;
        }

        @Nonnull
        public Builder dependentPullRequests(@Nullable Iterable<PullRequest> value) {
            Builder.addIf(Objects::nonNull, this.dependentPullRequests, value);
            return this;
        }

        @Nonnull
        public Builder sourceBranch(@Nullable Branch value) {
            this.sourceBranch = value;
            return this;
        }

        @Nonnull
        public Builder veto(@Nullable KeyedMessage value) {
            Builder.addIf(Objects::nonNull, this.vetoes, (Object)value);
            return this;
        }

        @Nonnull
        public Builder veto(@Nullable Iterable<KeyedMessage> values) {
            Builder.addIf(Objects::nonNull, this.vetoes, values);
            return this;
        }
    }
}

