/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupRequest;
import com.atlassian.stash.internal.pull.cleanup.dao.PullRequestPendingCleanupRequestDao;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Value;

public class PullRequestPendingRetargetingCheck
implements RepositoryMergeCheck {
    private final PullRequestPendingCleanupRequestDao dao;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final Duration pullRequestCleanupTimeout;

    public PullRequestPendingRetargetingCheck(PullRequestPendingCleanupRequestDao dao, FeatureManager featureManager, I18nService i18nService, @Value(value="${plugin.pullrequest.auto.merge.cleanup.timeout:180}") int pullRequestCleanupTimeoutSeconds) {
        this.dao = dao;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.pullRequestCleanupTimeout = Duration.ofSeconds(pullRequestCleanupTimeoutSeconds);
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        if (!this.featureManager.isEnabled((Feature)StandardFeature.PULL_REQUEST_AUTO_MERGE)) {
            return RepositoryHookResult.accepted();
        }
        return this.dao.findByFromRef(request.getRepository().getId(), request.getToRef().getId()).stream().filter(r -> {
            PullRequest pullRequest = r.getPullRequest();
            return pullRequest.getState() == PullRequestState.MERGED && pullRequest.getClosedDate() != null && pullRequest.getClosedDate().toInstant().isAfter(Instant.now().minus(this.pullRequestCleanupTimeout));
        }).filter(PullRequestCleanupRequest::isRetarget).map(this::rejected).findFirst().orElse(RepositoryHookResult.accepted());
    }

    private RepositoryHookResult rejected(PullRequestCleanupRequest pullRequestCleanupRequest) {
        return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.branch.deletion.mergecheck.pending.retargeting.summary", new Object[0]), (String)this.i18nService.getMessage("bitbucket.branch.deletion.mergecheck.pending.retargeting.detail", new Object[]{pullRequestCleanupRequest.getPullRequest().getId()}));
    }
}

