/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupRequest;
import com.atlassian.stash.internal.pull.cleanup.dao.AoPullRequestPendingCleanupRequest;
import com.atlassian.stash.internal.pull.cleanup.dao.PullRequestPendingCleanupRequestDao;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="pullRequestPendingCleanupRequestDao")
public class AoPullRequestPendingCleanupRequestDao
extends AbstractAoDao
implements PullRequestPendingCleanupRequestDao {
    private static final int BATCH_DELETE_SIZE = 100;
    private static final String BY_PULL_REQUEST_SQL = String.format("%s = ? AND %s = ?", "TO_REPOSITORY_ID", "PR_ID");
    private final PullRequestService pullRequestService;

    public AoPullRequestPendingCleanupRequestDao(ActiveObjects ao, PullRequestService pullRequestService) {
        super(ao);
        this.pullRequestService = pullRequestService;
    }

    @Override
    public void create(@Nonnull PullRequestCleanupRequest request) {
        Objects.requireNonNull(request, "request");
        PullRequest pullRequest = request.getPullRequest();
        if (this.findByPullRequest(pullRequest).isPresent()) {
            return;
        }
        this.ao.create(AoPullRequestPendingCleanupRequest.class, (Map)ImmutableMap.of((Object)"DELETE_SOURCE_REF", (Object)request.isDeleteSourceRef(), (Object)"FROM_REF_ID", (Object)pullRequest.getFromRef().getId(), (Object)"FROM_REPOSITORY_ID", (Object)pullRequest.getFromRef().getRepository().getId(), (Object)"PR_ID", (Object)pullRequest.getId(), (Object)"RETARGET_DEPENDENTS", (Object)request.isRetarget(), (Object)"TO_REPOSITORY_ID", (Object)AoPullRequestPendingCleanupRequestDao.repositoryId(pullRequest)));
    }

    @Override
    public boolean deleteByPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return this.ao.deleteWithSQL(AoPullRequestPendingCleanupRequest.class, BY_PULL_REQUEST_SQL, new Object[]{AoPullRequestPendingCleanupRequestDao.repositoryId(pullRequest), pullRequest.getId()}) > 0;
    }

    @Override
    public int deleteByPullRequests(int repositoryId, @Nonnull Set<Long> pullRequestIds) {
        Objects.requireNonNull(pullRequestIds, "pullRequestIds");
        return StreamSupport.stream(Iterables.partition(pullRequestIds, (int)100).spliterator(), false).mapToInt(partition -> {
            String sql = String.format("%s = ? AND %s IN (%s)", "TO_REPOSITORY_ID", "PR_ID", StringUtils.repeat((String)"?", (String)",", (int)partition.size()));
            return this.ao.deleteWithSQL(AoPullRequestPendingCleanupRequest.class, sql, Stream.concat(Stream.of(Integer.valueOf(repositoryId)), partition.stream()).toArray());
        }).sum();
    }

    @Override
    public int deleteByRepository(int repositoryId) {
        return this.ao.deleteWithSQL(AoPullRequestPendingCleanupRequest.class, String.format("%s = ?", "TO_REPOSITORY_ID"), new Object[]{repositoryId});
    }

    @Override
    public List<PullRequestCleanupRequest> findByFromRef(int repositoryId, String refId) {
        Query query = Query.select().where(String.format("%s = ? AND %s = ?", "FROM_REPOSITORY_ID", "FROM_REF_ID"), new Object[]{repositoryId, refId}).order("TO_REPOSITORY_ID,PR_ID");
        return (List)Arrays.stream((AoPullRequestPendingCleanupRequest[])this.ao.find(AoPullRequestPendingCleanupRequest.class, query)).map(aoRequest -> {
            PullRequest pullRequest = this.pullRequestService.getById(aoRequest.getToRepositoryId(), aoRequest.getPullRequestId());
            if (pullRequest == null) {
                return null;
            }
            return new PullRequestCleanupRequest.Builder(pullRequest).deleteSourceRef(aoRequest.isDeleteSourceRef()).retarget(aoRequest.isRetargetDependents()).build();
        }).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
    }

    @Override
    @Nonnull
    public Optional<PullRequestCleanupRequest> findByPullRequest(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Query query = Query.select().where(BY_PULL_REQUEST_SQL, new Object[]{AoPullRequestPendingCleanupRequestDao.repositoryId(pullRequest), pullRequest.getId()});
        return Arrays.stream((AoPullRequestPendingCleanupRequest[])this.ao.find(AoPullRequestPendingCleanupRequest.class, query)).findFirst().map(aoRequest -> new PullRequestCleanupRequest.Builder(pullRequest).deleteSourceRef(aoRequest.isDeleteSourceRef()).retarget(aoRequest.isRetargetDependents()).build());
    }

    private static int repositoryId(PullRequest pullRequest) {
        return pullRequest.getToRef().getRepository().getId();
    }
}

