/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.cleanup.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PullRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupRequest;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupResult;
import com.atlassian.stash.internal.pull.cleanup.PullRequestCleanupService;
import com.atlassian.stash.internal.pull.cleanup.rest.RestPullRequestCleanupRequest;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.stream.Collectors;

@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}")
@Singleton
public class PullRequestCleanupResource {
    private final PullRequestCleanupService pullRequestCleanupService;

    @Inject
    public PullRequestCleanupResource(PullRequestCleanupService pullRequestCleanupService) {
        this.pullRequestCleanupService = pullRequestCleanupService;
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response cleanup(@BeanParam PullRequestResolver pullRequestResolver, RestPullRequestCleanupRequest restPullRequestCleanupRequest) {
        PullRequestCleanupRequest pullRequestCleanupRequest = new PullRequestCleanupRequest.Builder(pullRequestResolver.getPullRequest()).deleteSourceRef(restPullRequestCleanupRequest.getDeleteSourceRef()).retarget(restPullRequestCleanupRequest.getRetargetDependents()).dryRun(false).build();
        PullRequestCleanupResult cleanupResult = this.pullRequestCleanupService.cleanup(pullRequestCleanupRequest);
        return this.toResponse(cleanupResult);
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response dryRun(@BeanParam PullRequestResolver pullRequestResolver, @QueryParam(value="deleteSourceRef") boolean deleteSourceRef, @QueryParam(value="retargetDependents") boolean retargetDependents) {
        PullRequestCleanupRequest pullRequestCleanupRequest = new PullRequestCleanupRequest.Builder(pullRequestResolver.getPullRequest()).deleteSourceRef(deleteSourceRef).retarget(retargetDependents).dryRun(true).build();
        PullRequestCleanupResult cleanupResult = this.pullRequestCleanupService.cleanup(pullRequestCleanupRequest);
        return this.toResponse(cleanupResult);
    }

    private Response toResponse(PullRequestCleanupResult cleanupResult) {
        if (cleanupResult.isVetoed()) {
            RestErrors.Builder errorBuilder = new RestErrors.Builder();
            cleanupResult.getVetoes().forEach(veto -> errorBuilder.add(new RestErrorMessage(veto.getLocalisedMessage())));
            return ResponseFactory.status((Response.Status)Response.Status.CONFLICT).entity((Object)errorBuilder.build()).build();
        }
        return ResponseFactory.ok(cleanupResult.getDependentPullRequests().stream().map(RestPullRequest::new).collect(Collectors.toList())).build();
    }
}

