/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.audit;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskAddedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskBulkDeletedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskEvent;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskModifiedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.model.RequiredTask;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class DefaultTaskEventConverter
implements AuditEventConverter<DefaultTaskEvent> {
    @VisibleForTesting
    static final String ACTION_REPOSITORY_BULK_DELETED_EVENT = "bitbucket.defaulttasks.audit.action.repositoryalltasksdeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_CREATED_EVENT = "bitbucket.defaulttasks.audit.action.repositorytaskcreated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_DELETED_EVENT = "bitbucket.defaulttasks.audit.action.repositorytaskdeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_UPDATED_EVENT = "bitbucket.defaulttasks.audit.action.repositorytaskmodified";
    @VisibleForTesting
    static final String ATTR_DELETED_COUNT = "bitbucket.defaulttasks.audit.attribute.deletedtaskscount";
    @VisibleForTesting
    static final String ATTR_DESCRIPTION = "bitbucket.defaulttasks.audit.attribute.description";
    @VisibleForTesting
    static final String ATTR_SOURCE_MATCHER = "bitbucket.defaulttasks.audit.attribute.sourcematcher";
    @VisibleForTesting
    static final String ATTR_SOURCE_MATCHER_TYPE = "bitbucket.defaulttasks.audit.attribute.sourcematchertype";
    @VisibleForTesting
    static final String ATTR_TARGET_MATCHER = "bitbucket.defaulttasks.audit.attribute.targetmatcher";
    @VisibleForTesting
    static final String ATTR_TARGET_MATCHER_TYPE = "bitbucket.defaulttasks.audit.attribute.targetmatchertype";

    @Nonnull
    public AuditEvent convert(final @Nonnull DefaultTaskEvent event, final @Nonnull AuditEvent.Builder builder) {
        RequiredTask task = event.getTask();
        event.getTask().getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                builder.actionI18nKey(DefaultTaskEventConverter.toRepositoryActionI18nKey(event)).categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
                return null;
            }
        });
        if (event instanceof DefaultTaskModifiedEvent) {
            this.addChangedValues(builder, task, ((DefaultTaskModifiedEvent)event).getOldTask());
        } else if (event instanceof DefaultTaskBulkDeletedEvent) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DELETED_COUNT, (String)String.valueOf(((DefaultTaskBulkDeletedEvent)event).getCount())).build());
        } else {
            this.addExtraAttributes(builder, task);
        }
        return builder.build();
    }

    @Nonnull
    private static String toRepositoryActionI18nKey(DefaultTaskEvent event) {
        if (event instanceof DefaultTaskAddedEvent) {
            return ACTION_REPOSITORY_CREATED_EVENT;
        }
        if (event instanceof DefaultTaskModifiedEvent) {
            return ACTION_REPOSITORY_UPDATED_EVENT;
        }
        if (event instanceof DefaultTaskBulkDeletedEvent) {
            return ACTION_REPOSITORY_BULK_DELETED_EVENT;
        }
        return ACTION_REPOSITORY_DELETED_EVENT;
    }

    private void addChangedValues(@Nonnull AuditEvent.Builder builder, @Nonnull RequiredTask task, @Nonnull RequiredTask oldTask) {
        if (!Objects.equals(oldTask.getDescription(), task.getDescription())) {
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_DESCRIPTION).from(oldTask.getDescription()).to(task.getDescription()).build());
        }
        if (!Objects.equals(oldTask.getSourceMatcher().getDisplayId(), task.getSourceMatcher().getDisplayId())) {
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_SOURCE_MATCHER).from(oldTask.getSourceMatcher().getDisplayId()).to(task.getSourceMatcher().getDisplayId()).build());
        }
        if (!Objects.equals(oldTask.getSourceMatcher().getType().getDisplayId(), task.getSourceMatcher().getType().getDisplayId())) {
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_SOURCE_MATCHER_TYPE).from(oldTask.getSourceMatcher().getType().getDisplayId()).to(task.getSourceMatcher().getType().getDisplayId()).build());
        }
        if (!Objects.equals(oldTask.getTargetMatcher().getDisplayId(), task.getTargetMatcher().getDisplayId())) {
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_TARGET_MATCHER).from(oldTask.getTargetMatcher().getDisplayId()).to(task.getTargetMatcher().getDisplayId()).build());
        }
        if (!Objects.equals(oldTask.getTargetMatcher().getType().getDisplayId(), task.getTargetMatcher().getType().getDisplayId())) {
            builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_TARGET_MATCHER_TYPE).from(oldTask.getTargetMatcher().getType().getDisplayId()).to(task.getTargetMatcher().getType().getDisplayId()).build());
        }
    }

    private void addExtraAttributes(@Nonnull AuditEvent.Builder builder, @Nonnull RequiredTask task) {
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_DESCRIPTION, (String)task.getDescription()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SOURCE_MATCHER, (String)task.getSourceMatcher().getDisplayId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_SOURCE_MATCHER_TYPE, (String)task.getSourceMatcher().getType().getDisplayId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TARGET_MATCHER, (String)task.getTargetMatcher().getDisplayId()).build());
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TARGET_MATCHER_TYPE, (String)task.getTargetMatcher().getType().getDisplayId()).build());
    }
}

