/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.defaulttasks.DefaultTaskSetRequest;
import com.atlassian.bitbucket.internal.defaulttasks.dao.AoDefaultTask;
import com.atlassian.bitbucket.internal.defaulttasks.dao.DefaultTaskDao;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AoDefaultTaskDao
extends AbstractAoDao
implements DefaultTaskDao {
    private static final String byResourceIdAndTypeQuery = String.format("%s = ? AND %s = ?", "RESOURCE_ID", "SCOPE_TYPE");
    private static final String byTaskIdQuery = String.format("%s = ?", "ID");
    private static final Logger log = LoggerFactory.getLogger(AoDefaultTaskDao.class);

    public AoDefaultTaskDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public int count(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        return this.ao.count(AoDefaultTask.class, byResourceIdAndTypeQuery, new Object[]{scope.getResourceId().get(), scope.getType()});
    }

    @Override
    @Nonnull
    public AoDefaultTask create(@Nonnull Scope scope, @Nonnull DefaultTaskSetRequest createRequest) {
        ImmutableMap params = ImmutableMap.builder().put((Object)"DESCRIPTION", (Object)createRequest.getDescription()).put((Object)"RESOURCE_ID", scope.getResourceId().get()).put((Object)"SCOPE_TYPE", (Object)scope.getType()).put((Object)"SOURCE_REF_VALUE", (Object)createRequest.getSourceMatcher().getId()).put((Object)"SOURCE_REF_TYPE", (Object)createRequest.getSourceMatcher().getType().getId()).put((Object)"TARGET_REF_VALUE", (Object)createRequest.getTargetMatcher().getId()).put((Object)"TARGET_REF_TYPE", (Object)createRequest.getTargetMatcher().getType().getId()).build();
        return (AoDefaultTask)this.ao.create(AoDefaultTask.class, (Map)params);
    }

    @Override
    public void delete(@Nonnull AoDefaultTask task) {
        this.ao.delete(new RawEntity[]{Objects.requireNonNull(task, "task")});
    }

    @Override
    public int deleteTasksByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        return this.ao.deleteWithSQL(AoDefaultTask.class, byResourceIdAndTypeQuery, new Object[]{scope.getResourceId().get(), scope.getType()});
    }

    @Override
    @Nonnull
    public AoDefaultTask[] findTasks(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        Query query = (Query)scope.accept((ScopeVisitor)new ScopeVisitor<Query>(this){

            public Query visit(@Nonnull ProjectScope projectScope) {
                return Query.select().where(byResourceIdAndTypeQuery, new Object[]{projectScope.getResourceId().get(), ScopeType.PROJECT}).order("ID");
            }

            public Query visit(@Nonnull RepositoryScope repositoryScope) {
                int repositoryId = (Integer)repositoryScope.getResourceId().get();
                int projectId = repositoryScope.getProject().getId();
                return Query.select().where("(" + byResourceIdAndTypeQuery + ") OR (" + byResourceIdAndTypeQuery + ")", new Object[]{projectId, ScopeType.PROJECT, repositoryId, ScopeType.REPOSITORY}).order("ID");
            }
        });
        return (AoDefaultTask[])this.ao.find(AoDefaultTask.class, query);
    }

    @Override
    @Nonnull
    public Optional<AoDefaultTask> getTaskById(@Nonnull Scope scope, long taskId) {
        Objects.requireNonNull(scope, "scope");
        Query query = Query.select().where("(" + byResourceIdAndTypeQuery + ") AND ( " + byTaskIdQuery + " )", new Object[]{scope.getResourceId().get(), scope.getType(), taskId});
        AoDefaultTask[] tasks = (AoDefaultTask[])this.ao.find(AoDefaultTask.class, query);
        if (tasks.length > 1) {
            log.warn("Multiple default tasks found for key {}", (Object)taskId);
        }
        return Arrays.stream(tasks).findFirst();
    }

    @Override
    @Nonnull
    public AoDefaultTask update(@Nonnull AoDefaultTask task, @Nonnull DefaultTaskSetRequest updateRequest) {
        Objects.requireNonNull(task, "task");
        Objects.requireNonNull(updateRequest, "updateRequest");
        task.setDescription(updateRequest.getDescription());
        task.setSourceMatcherId(updateRequest.getSourceMatcher().getId());
        task.setSourceMatcherType(updateRequest.getSourceMatcher().getType().getId());
        task.setTargetMatcherId(updateRequest.getTargetMatcher().getId());
        task.setTargetMatcherType(updateRequest.getTargetMatcher().getType().getId());
        task.save();
        return task;
    }
}

