/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.internal.defaulttasks.model.RequiredTask;
import com.atlassian.bitbucket.scope.Scope;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@TransactionAware
public abstract class DefaultTaskEvent
extends ApplicationEvent {
    private final RequiredTask task;

    protected DefaultTaskEvent(@Nonnull Object source, @Nonnull RequiredTask task) {
        super(source);
        this.task = Objects.requireNonNull(task, "task");
    }

    public long getId() {
        return this.task.getId();
    }

    @Nonnull
    public Scope getScope() {
        return this.task.getScope();
    }

    @Nonnull
    public String getSourceMatcherType() {
        return this.task.getSourceMatcher().getType().getId();
    }

    @Nonnull
    public String getTargetMatcherType() {
        return this.task.getTargetMatcher().getType().getId();
    }

    @Nonnull
    public RequiredTask getTask() {
        return this.task;
    }
}

