/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.internal.defaulttasks.rest.DefaultTasksResourceHelper;
import com.atlassian.bitbucket.internal.defaulttasks.rest.RestDefaultTask;
import com.atlassian.bitbucket.internal.defaulttasks.rest.RestDefaultTaskRequest;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key.")})
@Tag(name="Project")
@LicensedOnly
@Path(value="projects/{projectKey}/tasks")
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DefaultTasksProjectResource {
    private final DefaultTasksResourceHelper tasksResourceHelper;

    @Inject
    public DefaultTasksProjectResource(DefaultTasksResourceHelper tasksResourceHelper) {
        this.tasksResourceHelper = tasksResourceHelper;
    }

    @Operation(description="Creates a default task for the project.\n\nThe authenticated user must have **PROJECT_ADMIN** permission for this project to call the resource.", summary="Add a default task")
    @RequestBody(description="The task to be added", required=true, content={@Content(schema=@Schema(implementation=RestDefaultTaskRequest.class))})
    @ResponseDocs(value={@ResponseDoc(documentation="The default task", representation=RestDefaultTask.class, responseCode=200), @ResponseDoc(documentation="One or more of the following error cases occurred (check the error message for more details): \n\n\n- the description is empty- the sourceMatcher or targetMatcher is invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to add a default task", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404)})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response addDefaultTask(@BeanParam ScopeResolver scopeResolver, RestDefaultTaskRequest request) {
        return this.tasksResourceHelper.addTask(scopeResolver.getScope(), request);
    }

    @Operation(description="Delete all the default tasks for the supplied project\n\nThe authenticated user must have **PROJECT_ADMIN** permission for this project to call the resource.", summary="Deletes all default tasks for the project")
    @ResponseDocs(value={@ResponseDoc(documentation="The default tasks have been deleted successfully.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete default tasks", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteAllDefaultTasks(@BeanParam ScopeResolver scopeResolver) {
        return this.tasksResourceHelper.deleteAllTasks(scopeResolver.getScope());
    }

    @Operation(description="Delete a specific default task for a project.\n\nThe authenticated user must have **PROJECT_ADMIN** permission for this project to call the resource.", summary="Delete a specific default task")
    @Parameter(name="taskId", description="The ID of the default task", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The default task has been deleted successfully.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete default tasks", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project or task does not exist", restError=true, responseCode=404)})
    @DELETE
    @Path(value="/{taskId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteDefaultTask(@BeanParam ScopeResolver scopeResolver, @PathParam(value="taskId") long taskId) {
        return this.tasksResourceHelper.deleteTaskById(scopeResolver.getScope(), taskId);
    }

    @Operation(description="Retrieves the default tasks for the supplied project.\n\nThe authenticated user must have **PROJECT_VIEW** permission for this project to call the resource.", summary="Get a page of default tasks")
    @Parameter(name="markup", description="If present or \"true\", includes a markup-rendered description", in=ParameterIn.QUERY)
    @ResponseDocs(value={@ResponseDoc(documentation="A page of default tasks", paged=true, representation=RestDefaultTask.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete default tasks", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getDefaultTasks(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver, @QueryParam(value="markup") @DefaultValue(value="false") boolean markup) {
        return this.tasksResourceHelper.getTasks(scopeResolver.getScope(), pageRequestResolver.getPageRequest(), markup);
    }

    @Operation(description="Updates a default task for the supplied project.\n\nThe authenticated user must have **PROJECT_ADMIN** permission for this project to call the resource.", summary="Update a default task")
    @RequestBody(description="The task to be updated", required=true, content={@Content(schema=@Schema(implementation=RestDefaultTaskRequest.class))})
    @Parameter(name="taskId", description="The ID of the default task", in=ParameterIn.PATH)
    @ResponseDocs(value={@ResponseDoc(documentation="The default task", representation=RestDefaultTask.class, responseCode=200), @ResponseDoc(documentation="One or more of the following error cases occurred (check the error message for more details): \n\n\n- the provided taskId does not exist- the description is empty- the sourceMatcher or targetMatcher is invalid", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to add a default task", restError=true, responseCode=401), @ResponseDoc(documentation="The specified project does not exist", restError=true, responseCode=404)})
    @PUT
    @Path(value="/{taskId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateDefaultTask(@BeanParam ScopeResolver scopeResolver, @PathParam(value="taskId") int taskId, RestDefaultTaskRequest request) {
        return this.tasksResourceHelper.updateTask(scopeResolver.getScope(), request, taskId);
    }
}

