/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.rest;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.defaulttasks.DefaultTaskSetRequest;
import com.atlassian.bitbucket.internal.defaulttasks.model.RequiredTask;
import com.atlassian.bitbucket.internal.defaulttasks.rest.RestDefaultTask;
import com.atlassian.bitbucket.internal.defaulttasks.rest.RestDefaultTaskRequest;
import com.atlassian.bitbucket.internal.defaulttasks.service.RequiredTaskService;
import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DefaultTasksResourceHelper {
    private final I18nService i18nService;
    private final MarkupService markupService;
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;
    private final RequiredTaskService requiredTaskService;

    public DefaultTasksResourceHelper(I18nService i18nService, MarkupService markupService, RequiredTaskService requiredTaskService, RefMatcherProviderRegistry refMatcherProviderRegistry) {
        this.i18nService = i18nService;
        this.markupService = markupService;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
        this.requiredTaskService = requiredTaskService;
    }

    public Response addTask(@Nonnull Scope scope, @Nonnull RestDefaultTaskRequest request) {
        this.validateRequest(request);
        RequiredTask task = this.requiredTaskService.addTask(scope, new DefaultTaskSetRequest(this.getRefMatcher(scope, Objects.requireNonNull(request.getSourceMatcher())), this.getRefMatcher(scope, Objects.requireNonNull(request.getTargetMatcher())), request.getDescription()));
        RestDefaultTask response = new RestDefaultTask(task);
        return ResponseFactory.ok((Object)((Object)response)).build();
    }

    public Response deleteAllTasks(@Nonnull Scope scope) {
        this.requiredTaskService.deleteTasksByScope(scope);
        return ResponseFactory.noContent().build();
    }

    public Response deleteTaskById(@Nonnull Scope scope, long taskId) {
        this.requiredTaskService.deleteTaskById(scope, taskId);
        return ResponseFactory.noContent().build();
    }

    public Response getTasks(@Nonnull Scope scope, PageRequest pageRequest, boolean markup) {
        RestPage restDefaultTaskPage = new RestPage(this.requiredTaskService.getTasks(scope, pageRequest), task -> {
            RestDefaultTask restDefaultTask = new RestDefaultTask((RequiredTask)task);
            if (markup) {
                restDefaultTask.setHtml(this.markupService.render(task.getDescription(), new RenderContext.Builder().build()));
            }
            return restDefaultTask;
        });
        return ResponseFactory.ok((Object)restDefaultTaskPage).build();
    }

    public Response updateTask(@Nonnull Scope scope, @Nonnull RestDefaultTaskRequest request, long taskId) {
        this.validateRequest(request);
        DefaultTaskSetRequest setRequest = new DefaultTaskSetRequest(this.getRefMatcher(scope, Objects.requireNonNull(request.getSourceMatcher())), this.getRefMatcher(scope, Objects.requireNonNull(request.getTargetMatcher())), request.getDescription());
        RequiredTask task = this.requiredTaskService.updateTask(scope, taskId, setRequest);
        return ResponseFactory.ok((Object)((Object)new RestDefaultTask(task))).build();
    }

    @VisibleForTesting
    void validateDescription(@Nonnull String description) {
        if (StringUtils.isBlank((CharSequence)description)) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.description.required", new Object[0]));
        }
        if (description.length() >= 32768) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.description.length", new Object[]{32768, description.length()}));
        }
    }

    @VisibleForTesting
    void validateMatcher(@Nullable RestRefMatcher matcher, String field) {
        if (matcher == null || matcher.getType() == null || matcher.getId() == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.matcher.required", new Object[]{field}));
        }
        if (StringUtils.isBlank((CharSequence)matcher.getId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.matcher.id.required", new Object[]{field}));
        }
        if (StringUtils.isBlank((CharSequence)matcher.getType().getId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.matcher.type.required", new Object[]{field}));
        }
        if (matcher.getId().length() > 255) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.matcher.id.length", new Object[]{field, 255, matcher.getId().length()}));
        }
        if (matcher.getType().getId().length() > 255) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.matcher.type.length", new Object[]{field, 255, matcher.getType().getId().length()}));
        }
    }

    private RefMatcher getRefMatcher(@Nonnull Scope scope, @Nonnull RestRefMatcher restRefMatcher) {
        return (RefMatcher)Optional.ofNullable(this.refMatcherProviderRegistry.getProvider(restRefMatcher.getType().getId())).flatMap(refMatcherProvider -> refMatcherProvider.create(scope, restRefMatcher.getId())).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.rest.matcher.type.invalid", new Object[]{restRefMatcher.getType().getId()})));
    }

    private void validateRequest(@Nonnull RestDefaultTaskRequest request) {
        this.validateDescription(request.getDescription());
        this.validateMatcher(request.getSourceMatcher(), "sourceMatcher");
        this.validateMatcher(request.getTargetMatcher(), "targetMatcher");
    }
}

