/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.rest;

import com.atlassian.bitbucket.internal.defaulttasks.model.RequiredTask;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@JsonSerialize
public class RestDefaultTask
extends RestMapEntity {
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String SCOPE = "scope";
    private static final String SOURCE_MATCHER = "sourceMatcher";
    private static final String TARGET_MATCHER = "targetMatcher";

    public RestDefaultTask(@Nonnull RequiredTask task) {
        Objects.requireNonNull(task);
        this.put(ID, task.getId());
        this.put(SCOPE, new RestScope(task.getScope()));
        this.put(SOURCE_MATCHER, new RestRefMatcher(task.getSourceMatcher()));
        this.put(TARGET_MATCHER, new RestRefMatcher(task.getTargetMatcher()));
        this.put(DESCRIPTION, task.getDescription());
    }

    private RestDefaultTask(long id, RestScope restScope, RestRefMatcher sourceMatcher, RestRefMatcher targetMatcher, String description) {
        this.put(ID, id);
        this.put(SCOPE, restScope);
        this.put(SOURCE_MATCHER, sourceMatcher);
        this.put(TARGET_MATCHER, targetMatcher);
        this.put(DESCRIPTION, description);
    }

    @Nonnull
    @Schema(example="Default task description", accessMode=Schema.AccessMode.READ_ONLY)
    public String getDescription() {
        return this.getStringProperty(DESCRIPTION);
    }

    @Schema(example="1", accessMode=Schema.AccessMode.READ_ONLY)
    public long getId() {
        return this.getLongProperty(ID);
    }

    public void setHtml(String html) {
        this.put("html", html);
    }
}

