/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.defaulttasks.service;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.comment.AddCommentRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentSearchRequest;
import com.atlassian.bitbucket.comment.CommentService;
import com.atlassian.bitbucket.comment.CommentSeverity;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorState;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.defaulttasks.DefaultTaskSetRequest;
import com.atlassian.bitbucket.internal.defaulttasks.dao.AoDefaultTask;
import com.atlassian.bitbucket.internal.defaulttasks.dao.DefaultTaskDao;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskAddedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskBulkDeletedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskDeletedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.event.DefaultTaskModifiedEvent;
import com.atlassian.bitbucket.internal.defaulttasks.model.RequiredTask;
import com.atlassian.bitbucket.internal.defaulttasks.model.SimpleRequiredTask;
import com.atlassian.bitbucket.internal.defaulttasks.service.RequiredTaskService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class DefaultRequiredTaskService
implements RequiredTaskService {
    public static final int MAX_DEFAULT_TASKS = 100;
    private static final String BRANCH_TYPE = "BRANCH";
    private final CommentService commentService;
    private final DefaultTaskDao defaultTaskDao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionValidationService permissionValidationService;
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;
    private final SecurityService securityService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;

    public DefaultRequiredTaskService(CommentService commentService, DefaultTaskDao defaultTaskDao, EventPublisher eventPublisher, I18nService i18nService, PermissionValidationService permissionValidationService, RefMatcherProviderRegistry refMatcherProviderRegistry, SecurityService securityService, TransactionTemplate transactionTemplate, UserService userService) {
        this.commentService = commentService;
        this.eventPublisher = eventPublisher;
        this.defaultTaskDao = defaultTaskDao;
        this.i18nService = i18nService;
        this.permissionValidationService = permissionValidationService;
        this.securityService = securityService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
    }

    @Override
    @Nonnull
    public RequiredTask addTask(@Nonnull Scope scope, @Nonnull DefaultTaskSetRequest createRequest) {
        Objects.requireNonNull(scope, "scope");
        Objects.requireNonNull(createRequest, "createRequest");
        this.validateAdminPermission(scope);
        this.validateMatchers(createRequest.getSourceMatcher(), createRequest.getTargetMatcher());
        this.validateDuplicateTask(scope, createRequest.getSourceMatcher(), createRequest.getTargetMatcher(), createRequest.getDescription());
        AoDefaultTask aoTask = (AoDefaultTask)this.transactionTemplate.execute(() -> {
            int count = this.defaultTaskDao.count(scope);
            if (count >= 100) {
                throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.too.many.tasks", new Object[]{100}));
            }
            return this.defaultTaskDao.create(scope, createRequest);
        });
        SimpleRequiredTask taskAdded = this.toSimpleTask(scope, aoTask);
        this.eventPublisher.publish((Object)new DefaultTaskAddedEvent(this, taskAdded));
        return taskAdded;
    }

    @Override
    public void deleteTaskById(@Nonnull Scope scope, long taskId) {
        Objects.requireNonNull(scope, "scope");
        this.validateAdminPermission(scope);
        this.transactionTemplate.execute(() -> this.defaultTaskDao.getTaskById(scope, taskId).map(task -> {
            this.defaultTaskDao.delete((AoDefaultTask)task);
            this.eventPublisher.publish((Object)new DefaultTaskDeletedEvent(this, this.toSimpleTask(scope, (AoDefaultTask)task)));
            return null;
        }));
    }

    @Override
    public void deleteTasksByScope(@Nonnull Scope scope) {
        Objects.requireNonNull(scope, "scope");
        this.validateAdminPermission(scope);
        this.transactionTemplate.execute(() -> {
            AoDefaultTask[] tasks = this.defaultTaskDao.findTasks(scope);
            if (tasks.length > 0) {
                int tasksDeleted = this.defaultTaskDao.deleteTasksByScope(scope);
                this.eventPublisher.publish((Object)new DefaultTaskBulkDeletedEvent(this, this.toSimpleTask(scope, tasks[0]), tasksDeleted));
            }
            return null;
        });
    }

    @Override
    @Nonnull
    public Page<RequiredTask> getTasks(@Nonnull Scope scope, PageRequest pageRequest) {
        Objects.requireNonNull(scope);
        this.validateReadPermission(scope);
        return PageUtils.createPage(this.getAllTasks(scope), (PageRequest)pageRequest);
    }

    @EventListener
    public void onProjectDeletionRequested(@Nonnull ProjectDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.deleteTasksByScope((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onPullRequestOpenedListener(@Nonnull PullRequestOpenedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        Set<String> uniqueDescriptions = this.getTasksBySourceTargetRef(pullRequest.getFromRef(), (Ref)pullRequest.getToRef(), pullRequest.getToRef().getRepository()).stream().map(RequiredTask::getDescription).collect(Collectors.toSet());
        uniqueDescriptions.forEach(description -> this.addTaskToPullRequest(pullRequest, (String)description));
    }

    @EventListener
    public void onPullRequestUpdated(@Nonnull PullRequestUpdatedEvent event) {
        if (event.getPreviousToBranch() != null && !Objects.equals(event.getPreviousToBranch().getId(), event.getPullRequest().getToRef().getId())) {
            PullRequest pullRequest = event.getPullRequest();
            CommentSearchRequest commentSearchRequest = new CommentSearchRequest.Builder((Commentable)pullRequest).author((ApplicationUser)this.userService.getSystemServiceUser()).anchorState(CommentThreadDiffAnchorState.ALL).severity(CommentSeverity.BLOCKER).build();
            Set existingTasks = this.commentService.search(commentSearchRequest, PageUtils.newRequest((int)0, (int)200)).stream().map(Comment::getText).collect(Collectors.toSet());
            this.getTasksBySourceTargetRef(pullRequest.getFromRef(), (Ref)pullRequest.getToRef(), pullRequest.getToRef().getRepository()).stream().filter(task -> !existingTasks.contains(task.getDescription())).forEach(task -> this.addTaskToPullRequest(pullRequest, task.getDescription()));
        }
    }

    @EventListener
    public void onRepositoryDeletionRequested(@Nonnull RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.deleteTasksByScope((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    @Override
    @Nonnull
    public RequiredTask updateTask(@Nonnull Scope scope, long taskId, @Nonnull DefaultTaskSetRequest updateRequest) {
        Objects.requireNonNull(scope);
        Objects.requireNonNull(updateRequest);
        this.validateAdminPermission(scope);
        this.validateMatchers(updateRequest.getSourceMatcher(), updateRequest.getTargetMatcher());
        this.validateDuplicateTask(scope, updateRequest.getSourceMatcher(), updateRequest.getTargetMatcher(), updateRequest.getDescription());
        return (RequiredTask)this.transactionTemplate.execute(() -> {
            AoDefaultTask aoOldTask = this.defaultTaskDao.getTaskById(scope, taskId).orElseThrow(() -> new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.task.not.found", new Object[]{taskId})));
            SimpleRequiredTask oldTask = this.toSimpleTask(scope, aoOldTask);
            AoDefaultTask aoTask = this.defaultTaskDao.update(aoOldTask, updateRequest);
            SimpleRequiredTask newTask = this.toSimpleTask(scope, aoTask);
            this.eventPublisher.publish((Object)new DefaultTaskModifiedEvent(this, newTask, oldTask));
            return newTask;
        });
    }

    @Nonnull
    @VisibleForTesting
    SimpleRequiredTask toSimpleTask(@Nonnull Scope scope, @Nonnull AoDefaultTask aoTask) {
        return new SimpleRequiredTask(scope, aoTask.getId(), this.getRefMatcher(scope, aoTask.getSourceMatcherId(), aoTask.getSourceMatcherType()), this.getRefMatcher(scope, aoTask.getTargetMatcherId(), aoTask.getTargetMatcherType()), aoTask.getDescription());
    }

    private void addTaskToPullRequest(@Nonnull PullRequest pullRequest, @Nonnull String description) {
        this.securityService.impersonating((ApplicationUser)this.userService.getSystemServiceUser(), "Adding a default task").withPermission(Permission.REPO_READ).call(() -> this.commentService.addComment(((AddCommentRequest.Builder)((AddCommentRequest.Builder)new AddCommentRequest.Builder((Commentable)pullRequest, description).severity(CommentSeverity.BLOCKER)).pending(false)).build()));
    }

    private List<RequiredTask> getAllTasks(@Nonnull Scope scope) {
        AoDefaultTask[] aoTasks = (AoDefaultTask[])this.transactionTemplate.execute(() -> this.defaultTaskDao.findTasks(scope));
        return Arrays.stream(aoTasks).map(aoTask -> this.toSimpleTask(this.toScope(aoTask.getScopeType(), scope), (AoDefaultTask)aoTask)).collect(Collectors.toList());
    }

    private RefMatcher getRefMatcher(@Nonnull Scope scope, @Nonnull String matcherId, @Nonnull String matcherType) {
        RefMatcherProvider provider = this.refMatcherProviderRegistry.getProvider(matcherType);
        if (provider == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.ref.matcher.provider.not.found", new Object[]{matcherType}));
        }
        return (RefMatcher)provider.create(scope, matcherId).orElseThrow(() -> new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.cannot.create.provider", new Object[]{matcherType, scope})));
    }

    private List<RequiredTask> getTasksBySourceTargetRef(@Nonnull PullRequestRef sourceRef, @Nonnull Ref targetRef, @Nonnull Repository repository) {
        List<RequiredTask> tasks = this.getAllTasks((Scope)Scopes.repository((Repository)repository));
        return tasks.stream().filter(task -> task.getSourceMatcher().matches((MinimalRef)sourceRef)).filter(task -> task.getTargetMatcher().matches((MinimalRef)targetRef)).collect(Collectors.toList());
    }

    private Scope toScope(ScopeType scopeType, Scope scope) {
        if (scopeType == scope.getType()) {
            return scope;
        }
        return Scopes.project((Project)((RepositoryScope)scope).getProject());
    }

    private void validateAdminPermission(@Nonnull Scope scope) {
        this.validateNotPersonalProject(scope);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultRequiredTaskService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultRequiredTaskService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }

            public Void visit(@Nonnull GlobalScope scope) {
                throw new ArgumentValidationException(DefaultRequiredTaskService.this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.invalid.scope", new Object[0]));
            }
        });
        this.validateResourceIdForScope(scope);
    }

    private void validateDuplicateTask(Scope scope, RefMatcher sourceMatcher, RefMatcher targetMatcher, String description) {
        Optional<RequiredTask> duplicateTask = this.getAllTasks(scope).stream().filter(task -> task.getSourceMatcher().getDisplayId().equals(sourceMatcher.getDisplayId()) && task.getTargetMatcher().getDisplayId().equals(targetMatcher.getDisplayId()) && task.getDescription().equals(description)).findAny();
        if (duplicateTask.isPresent()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.default.task.same", new Object[0]));
        }
    }

    private void validateMatchers(RefMatcher sourceMatcher, RefMatcher targetMatcher) {
        if (BRANCH_TYPE.equals(sourceMatcher.getType().getId()) && BRANCH_TYPE.equals(targetMatcher.getType().getId()) && sourceMatcher.getId().equals(targetMatcher.getId())) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.source.target.matcher.same", new Object[0]));
        }
    }

    private void validateNotPersonalProject(@Nonnull Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultRequiredTaskService.this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.personal.project", new Object[0]));
                }
                return null;
            }
        });
    }

    private void validateReadPermission(@Nonnull Scope scope) {
        this.validateNotPersonalProject(scope);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultRequiredTaskService.this.permissionValidationService.validateForProject(projectScope.getProject(), Permission.PROJECT_VIEW);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultRequiredTaskService.this.permissionValidationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_READ);
                return null;
            }

            public Void visit(@Nonnull GlobalScope scope) {
                throw new ArgumentValidationException(DefaultRequiredTaskService.this.i18nService.createKeyedMessage("bitbucket.defaulttasks.error.invalid.scope", new Object[0]));
            }
        });
        this.validateResourceIdForScope(scope);
    }

    private void validateResourceIdForScope(@Nonnull Scope scope) {
        if (!scope.getResourceId().isPresent()) {
            throw new UnsupportedOperationException("No resource id found with the associated scope " + String.valueOf(scope.getType()));
        }
    }
}

