/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.SimplePerson;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public enum AuthorNameType {
    DISPLAYNAME{

        @Override
        protected String getName(ApplicationUser author) {
            return author.getDisplayName();
        }
    }
    ,
    USERNAME;


    @Nonnull
    public Person convert(@Nonnull Person author) {
        if (author instanceof ApplicationUser) {
            return new SimplePerson(this.getName((ApplicationUser)author), author.getEmailAddress());
        }
        return author;
    }

    @Nonnull
    public static AuthorNameType parseConfig(String order) {
        try {
            return AuthorNameType.valueOf(StringUtils.upperCase((String)order));
        }
        catch (RuntimeException runtimeException) {
            return DISPLAYNAME;
        }
    }

    protected String getName(ApplicationUser author) {
        return author.getName();
    }
}

