/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.util.CancelState;
import com.atlassian.bitbucket.util.MoreFiles;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.server.DataStoreListener;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFileAttributeView;

public class BundledResources
implements DataStoreListener {
    private final GitScmConfig config;

    public BundledResources(GitScmConfig config) {
        this.config = config;
    }

    public void onAttach(@Nonnull DataStore dataStore, @Nonnull CancelState cancelState) {
    }

    public void unpack() throws IOException {
        BundledResources.installScript(this.config.getAskPassScript());
    }

    private static void copy(InputStream source, Path target) throws IOException {
        Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
    }

    private static void installScript(Path scriptFile) throws IOException {
        BundledResources.copy(BundledResources.class.getResourceAsStream("/scripts/" + String.valueOf(scriptFile.getFileName())), scriptFile);
        if (BundledResources.isPosixFilesystem(scriptFile)) {
            MoreFiles.setExecutable((Path)scriptFile);
        }
    }

    private static boolean isPosixFilesystem(Path path) throws IOException {
        FileStore fileStore = Files.getFileStore(path);
        return fileStore.supportsFileAttributeView(PosixFileAttributeView.class);
    }
}

