/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountUpDownLatch {
    private final Sync sync;

    public CountUpDownLatch(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count must be >= 0");
        this.sync = new Sync(count);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, timeUnit.toNanos(timeout));
    }

    public void countDown() {
        this.sync.countDown();
    }

    public void countUp() {
        this.sync.countUp();
    }

    public int getCount() {
        return this.sync.getCount();
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        Sync(int startCount) {
            this.setState(startCount);
        }

        private void countDown() {
            this.releaseShared(1);
        }

        private void countUp() {
            int newValue;
            int value;
            while (!this.compareAndSetState(value = this.getCount(), newValue = value + 1)) {
            }
        }

        int getCount() {
            return this.getState();
        }

        @Override
        protected int tryAcquireShared(int arg) {
            return this.getCount() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            int newValue;
            int value;
            do {
                if ((value = this.getCount()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(value, newValue = value - 1));
            return newValue == 0;
        }
    }
}

