/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.stash.internal.scm.git.CountUpDownLatch;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;

public class CountingGitWriteTracker
implements GitWriteTracker {
    private final CountUpDownLatch latch = new CountUpDownLatch(0);

    @Override
    public void onWriteStart() {
        this.latch.countUp();
    }

    @Override
    public void onWriteEnd() {
        this.latch.countDown();
    }

    public boolean drain(long timeout, @Nonnull TimeUnit unit) {
        try {
            return this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

