/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.GitCommandCreator;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.DefaultGitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.DefaultGitScmCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.GitCommandBuilderConfigurer;
import com.atlassian.stash.internal.scm.git.command.GitFreeFormCommandBuilder;
import com.atlassian.stash.internal.scm.git.command.InternalGitCommandBuilderFactory;
import com.atlassian.stash.internal.scm.git.command.InternalGitScmCommandBuilder;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class DefaultGitCommandBuilderFactory
implements InternalGitCommandBuilderFactory {
    private final GitCommandCreator commandCreator;
    private final GitScmConfig config;
    private final List<GitCommandBuilderConfigurer> configurers;
    private final I18nService i18nService;

    public DefaultGitCommandBuilderFactory(GitCommandCreator commandCreator, GitScmConfig config, List<GitCommandBuilderConfigurer> configurers, I18nService i18nService) {
        this.commandCreator = commandCreator;
        this.config = config;
        this.configurers = ImmutableList.copyOf(configurers);
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public InternalGitScmCommandBuilder builder() {
        return new DefaultGitScmCommandBuilder(this.freeFormBuilder(null), this.config, this.i18nService, null);
    }

    @Override
    @Nonnull
    public InternalGitScmCommandBuilder builder(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        return new DefaultGitScmCommandBuilder(this.freeFormBuilder(repository), this.config, this.i18nService, repository);
    }

    protected GitFreeFormCommandBuilder freeFormBuilder(Repository repository) {
        return this.configure(new DefaultGitFreeFormCommandBuilder(this.i18nService, this.commandCreator, this.config, repository));
    }

    private GitFreeFormCommandBuilder configure(GitFreeFormCommandBuilder builder) {
        for (GitCommandBuilderConfigurer configurer : this.configurers) {
            configurer.configure(builder);
        }
        return builder;
    }
}

