/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffOptions;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDiffRenames;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffCoreBuilder;
import com.atlassian.bitbucket.scm.git.command.diff.GitDiffRenames;
import com.atlassian.stash.internal.scm.git.AuthorNameType;
import com.atlassian.stash.internal.scm.git.GitRepositoryConfig;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.command.diff.DiffStrategy;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGitRepositoryConfig
implements GitRepositoryConfig {
    public static final String PROP_AUTHOR_NAME_TYPE = "author.name.type";
    public static final String PROP_DIFF_RENAMES = "diff.renames";
    public static final String PROP_DIFF_RENAMES_THRESHOLD = "diff.renames.threshold";
    private static final Logger log = LoggerFactory.getLogger(DefaultGitRepositoryConfig.class);
    private static final Function<String, GitDiffRenames> TO_RENAME_MODE = value -> {
        if (value == null) {
            return GitDiffRenames.FIND_COPIES;
        }
        if ("rename".equals(value) || "renames".equals(value)) {
            return GitDiffRenames.FIND_RENAMES;
        }
        if ("off".equals(value)) {
            return GitDiffRenames.OFF;
        }
        return value.endsWith("+") ? GitDiffRenames.FIND_COPIES_HARDER : GitDiffRenames.FIND_COPIES;
    };
    private static final Function<String, Integer> TO_RENAME_THRESHOLD = value -> {
        if (value == null) {
            return null;
        }
        int threshold = Integer.parseInt(value);
        if (threshold < 1) {
            log.warn("The configured rename threshold, {}, is invalid; defaulting to 1", value);
            return 1;
        }
        if (threshold > 99) {
            log.warn("The configured rename threshold, {}, is invalid; defaulting to 99", value);
            return 99;
        }
        return threshold;
    };
    private final GitScmConfig config;

    public DefaultGitRepositoryConfig(GitScmConfig config) {
        this.config = config;
    }

    @Override
    @Nonnull
    public AuthorNameType getAuthorNameType(@Nonnull Repository repository) {
        return AuthorNameType.parseConfig(this.getProperty(repository, PROP_AUTHOR_NAME_TYPE));
    }

    @Override
    @Nonnull
    public DiffStrategy getDiffStrategy(@Nonnull Repository repository) {
        return new ConfiguredDiffStrategy(repository);
    }

    private String getProperty(Repository repository, String key) {
        String fullKey;
        Objects.requireNonNull(repository, "repository");
        String value = null;
        Iterator<String> iterator = DefaultGitRepositoryConfig.generateKeys(repository, key).iterator();
        while (iterator.hasNext() && (value = StringUtils.trimToNull((String)this.config.getProperty(fullKey = iterator.next()))) == null) {
        }
        return value;
    }

    private <T> T getProperty(Repository repository, String key, Function<String, T> transform) {
        return transform.apply(this.getProperty(repository, key));
    }

    private static List<String> generateKeys(Repository repository, String base) {
        ArrayDeque<String> pieces = new ArrayDeque<String>(3);
        pieces.add(base);
        pieces.add(repository.getProject().getKey());
        pieces.add(repository.getSlug());
        ImmutableList.Builder keys = ImmutableList.builder();
        do {
            keys.add((Object)StringUtils.join(pieces, (String)"."));
            pieces.removeLast();
        } while (!pieces.isEmpty());
        return keys.build();
    }

    private class ConfiguredDiffStrategy
    implements DiffStrategy {
        private final Repository repository;

        private ConfiguredDiffStrategy(Repository repository) {
            this.repository = repository;
        }

        @Override
        @Nonnull
        public <T extends GitDiffCoreBuilder<T>> T apply(@Nonnull T builder) {
            GitDiffRenames mode = DefaultGitRepositoryConfig.this.getProperty(this.repository, DefaultGitRepositoryConfig.PROP_DIFF_RENAMES, TO_RENAME_MODE);
            Integer threshold = null;
            if (mode.supportsThreshold()) {
                threshold = DefaultGitRepositoryConfig.this.getProperty(this.repository, DefaultGitRepositoryConfig.PROP_DIFF_RENAMES_THRESHOLD, TO_RENAME_THRESHOLD);
            }
            return (T)builder.renames(mode, threshold);
        }

        @Override
        @Nonnull
        public RpcDiffOptions.Builder apply(@Nonnull RpcDiffOptions.Builder builder) {
            Integer threshold;
            GitDiffRenames mode = DefaultGitRepositoryConfig.this.getProperty(this.repository, DefaultGitRepositoryConfig.PROP_DIFF_RENAMES, TO_RENAME_MODE);
            builder.setRenames(this.mapRenames(mode));
            if (mode.supportsThreshold() && (threshold = DefaultGitRepositoryConfig.this.getProperty(this.repository, DefaultGitRepositoryConfig.PROP_DIFF_RENAMES_THRESHOLD, TO_RENAME_THRESHOLD)) != null) {
                builder.setRenameThreshold(threshold.intValue());
            }
            return builder;
        }

        private RpcDiffRenames mapRenames(GitDiffRenames renames) {
            switch (renames) {
                case FIND_COPIES: {
                    return RpcDiffRenames.RENAMES_COPIES;
                }
                case FIND_COPIES_HARDER: {
                    return RpcDiffRenames.RENAMES_MORE_COPIES;
                }
                case FIND_RENAMES: {
                    return RpcDiffRenames.RENAMES_ON;
                }
                case OFF: {
                    return RpcDiffRenames.RENAMES_OFF;
                }
            }
            return RpcDiffRenames.RENAMES_UNSPECIFIED;
        }
    }
}

