/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.AbstractScm;
import com.atlassian.bitbucket.scm.PluginMergeStrategies;
import com.atlassian.bitbucket.scm.PluginMergeStrategy;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmStatus;
import com.atlassian.bitbucket.scm.SimpleScmStatus;
import com.atlassian.bitbucket.scm.git.GitException;
import com.atlassian.bitbucket.scm.git.GitFeature;
import com.atlassian.bitbucket.scm.git.GitIntegrityCheckCommandFactory;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.scm.git.GitScm;
import com.atlassian.bitbucket.scm.git.GitWorkTreeBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.GitCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitCompareCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitExtendedCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitMirrorCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.mirror.PluginMirrorCommandFactory;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.util.Drainable;
import com.atlassian.bitbucket.util.Version;
import com.atlassian.stash.internal.scm.InternalScm;
import com.atlassian.stash.internal.scm.git.GitAgent;
import com.atlassian.stash.internal.scm.git.GitScmConfig;
import com.atlassian.stash.internal.scm.git.GitWriteTracker;
import com.atlassian.stash.internal.scm.git.binary.GitBinaryHelper;
import com.atlassian.stash.internal.scm.git.merge.GitMergeStrategy;
import com.atlassian.stash.internal.scm.hook.PluginHookHandlerFactory;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class DefaultGitScm
extends AbstractScm
implements GitScm,
InternalScm,
Drainable {
    private static final Set<ScmFeature> FEATURES = ImmutableSet.of((Object)ScmFeature.ARCHIVE, (Object)ScmFeature.BULK_CONTENT, (Object)ScmFeature.COMMAND_BUILDERS, (Object)ScmFeature.COMPARE, (Object)ScmFeature.CROSS_REPOSITORY, (Object)ScmFeature.EDIT_FILE, (Object[])new ScmFeature[]{ScmFeature.FORK, ScmFeature.HOOKS, ScmFeature.INTEGRITY_CHECKS, ScmFeature.MERGE_STRATEGIES, ScmFeature.MERGE, ScmFeature.MIRRORS, ScmFeature.PULL_REQUESTS, ScmFeature.PUSH, ScmFeature.REFS, ScmFeature.SIGNED_OBJECTS, ScmFeature.UPDATE_DEFAULT_BRANCH});
    protected final I18nService i18nService;
    private final GitAgent agent;
    private final GitCommandBuilderFactory builderFactory;
    private final GitBulkContentCommandFactory bulkContentCommandFactory;
    private final GitCommandFactory commandFactory;
    private final GitCompareCommandFactory compareCommandFactory;
    private final GitScmConfig config;
    private final GitExtendedCommandFactory extendedCommandFactory;
    private final PluginHookHandlerFactory hookHandlerFactory;
    private final GitIntegrityCheckCommandFactory integrityCheckCommandFactory;
    private final GitMergeStrategies mergeStrategies;
    private final GitMirrorCommandFactory mirrorCommandFactory;
    private final GitPullRequestCommandFactory pullRequestCommandFactory;
    private final GitRefCommandFactory refCommandFactory;
    private final GitWorkTreeBuilderFactory workTreeBuilderFactory;
    private final GitWriteTracker writeTracker;
    private volatile ScmStatus status;

    public DefaultGitScm(GitAgent agent, GitCommandBuilderFactory builderFactory, GitBulkContentCommandFactory bulkContentCommandFactory, GitCommandFactory commandFactory, GitCompareCommandFactory compareCommandFactory, GitScmConfig config, GitExtendedCommandFactory extendedCommandFactory, FeatureManager featureManager, PluginHookHandlerFactory hookHandlerFactory, I18nService i18nService, GitIntegrityCheckCommandFactory integrityCheckCommandFactory, GitMirrorCommandFactory mirrorCommandFactory, GitPullRequestCommandFactory pullRequestCommandFactory, GitRefCommandFactory refCommandFactory, GitWorkTreeBuilderFactory workTreeBuilderFactory, GitWriteTracker writeTracker) {
        super(FEATURES);
        this.agent = agent;
        this.builderFactory = builderFactory;
        this.bulkContentCommandFactory = bulkContentCommandFactory;
        this.commandFactory = commandFactory;
        this.compareCommandFactory = compareCommandFactory;
        this.config = config;
        this.extendedCommandFactory = extendedCommandFactory;
        this.hookHandlerFactory = hookHandlerFactory;
        this.i18nService = i18nService;
        this.integrityCheckCommandFactory = integrityCheckCommandFactory;
        this.mirrorCommandFactory = mirrorCommandFactory;
        this.pullRequestCommandFactory = pullRequestCommandFactory;
        this.refCommandFactory = refCommandFactory;
        this.workTreeBuilderFactory = workTreeBuilderFactory;
        this.writeTracker = writeTracker;
        this.mergeStrategies = new GitMergeStrategies(featureManager.isEnabled((Feature)GitFeature.REBASE_WORKFLOWS));
    }

    public boolean drain(long timeout, @Nonnull TimeUnit unit) {
        return this.writeTracker.drain(timeout, unit);
    }

    @Nonnull
    public GitBulkContentCommandFactory getBulkContentCommandFactory() {
        return this.bulkContentCommandFactory;
    }

    @Nonnull
    public GitCommandBuilderFactory getCommandBuilderFactory() {
        return this.builderFactory;
    }

    @Nonnull
    public GitCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    @Nonnull
    public GitCompareCommandFactory getCompareCommandFactory() {
        return this.compareCommandFactory;
    }

    @Nonnull
    public MinimalRef getDefaultBranch(@Nonnull Repository repository) {
        String head = this.agent.getHead(repository);
        Branch defaultBranch = this.agent.resolveBranch(repository, head, true);
        if (defaultBranch == null) {
            return ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(GitRefPattern.HEADS.unqualify(head))).id(head)).type((RefType)StandardRefType.BRANCH).build();
        }
        return defaultBranch;
    }

    @Nonnull
    public GitExtendedCommandFactory getExtendedCommandFactory() {
        return this.extendedCommandFactory;
    }

    @Nonnull
    public PluginHookHandlerFactory getHookHandlerFactory() {
        return this.hookHandlerFactory;
    }

    @Nonnull
    public String getId() {
        return "git";
    }

    @Nonnull
    public GitIntegrityCheckCommandFactory getIntegrityCheckCommandFactory() {
        return this.integrityCheckCommandFactory;
    }

    @Nonnull
    public PluginMergeStrategies getMergeStrategies() {
        return this.mergeStrategies;
    }

    @Nonnull
    public Version getMinimumVersion() {
        return GitBinaryHelper.MINIMUM_VERSION;
    }

    @Nonnull
    public PluginMirrorCommandFactory getMirrorCommandFactory() {
        return this.mirrorCommandFactory;
    }

    @Nonnull
    public String getName() {
        return "Git";
    }

    @Nonnull
    public GitPullRequestCommandFactory getPullRequestCommandFactory() {
        return this.pullRequestCommandFactory;
    }

    @Nonnull
    public GitRefCommandFactory getRefCommandFactory() {
        return this.refCommandFactory;
    }

    @Nonnull
    public ScmStatus getStatus() {
        if (this.status == null) {
            try {
                Version version = this.config.getVersion();
                this.status = SimpleScmStatus.available((KeyedMessage)this.i18nService.createKeyedMessage("bitbucket.git.info", new Object[]{Product.NAME, this.config.getBinary(), version}));
            }
            catch (GitException e) {
                this.status = SimpleScmStatus.unavailable((KeyedMessage)e.getKeyedMessage());
            }
        }
        return this.status;
    }

    @Nonnull
    public Optional<Version> getVersion() {
        return this.config.getInstalledVersion();
    }

    @Nonnull
    public GitWorkTreeBuilderFactory getWorkTreeBuilderFactory() {
        return this.workTreeBuilderFactory;
    }

    public boolean isEmpty(@Nonnull Repository repository) {
        return this.agent.isEmpty(repository);
    }

    private static class GitMergeStrategies
    implements PluginMergeStrategies {
        private final Set<PluginMergeStrategy> strategies;

        GitMergeStrategies(boolean allowRebase) {
            ImmutableSet.Builder builder = ImmutableSet.builder().add((Object[])new PluginMergeStrategy[]{GitMergeStrategy.NO_FF, GitMergeStrategy.FF, GitMergeStrategy.FF_ONLY});
            if (allowRebase) {
                builder.add((Object[])new PluginMergeStrategy[]{GitMergeStrategy.REBASE_NO_FF, GitMergeStrategy.REBASE_FF_ONLY});
            }
            builder.add((Object[])new PluginMergeStrategy[]{GitMergeStrategy.SQUASH, GitMergeStrategy.SQUASH_FF_ONLY});
            this.strategies = builder.build();
        }

        @Nonnull
        public String getHelpTopic() {
            return "bitbucket.help.git.mergestrategies";
        }

        @Nonnull
        public Set<PluginMergeStrategy> getStrategies() {
            return this.strategies;
        }
    }
}

